package com.zbkj.common.model.bcx;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * 平台服务费-配置表
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("bcx_platform_fee_config")
@ApiModel(value = "BcxPlatformFeeConfig对象", description = "平台服务费-配置表")
public class BcxPlatformFeeConfig implements Serializable {
    private static final long serialVersionUID=1L;

    @ApiModelProperty(value = "平台服务费配置id")
    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    @ApiModelProperty(value = "0-平台 1-商户 3-商品 4-sku")
    private Integer level;

    @ApiModelProperty(value = "商户id")
    private Integer merId;

    @ApiModelProperty(value = "商品id")
    private Integer productId;

    @ApiModelProperty(value = "sku id")
    private Integer skuId;

    @ApiModelProperty(value = "售卖服务费类型：0-百分比 1-金额")
    private Integer sellFeeType;

    @ApiModelProperty(value = "售卖服务费")
    private BigDecimal sellFee;

    @ApiModelProperty(value = "销售分账优先级 0-平台 1-商户")
    private Integer sellFeePriority;

    @ApiModelProperty(value = "租赁服务费类型：0-百分比 1-金额")
    private Integer leaseFeeType;

    @ApiModelProperty(value = "租赁服务费")
    private BigDecimal leaseFee;

    @ApiModelProperty(value = "赁分账优先级 0-平台 1-商户")
    private Integer leaseFeePriority;

    @ApiModelProperty(value = "分期分账优先级 0-平台 1-商户")
    private Integer instalmentFeePriority;

    @ApiModelProperty(value = "分期服务费类型：0-百分比 1-金额")
    private Integer instalmentFeeType;

    @ApiModelProperty(value = "分期3期 服务费")
    private BigDecimal period3Fee;

    @ApiModelProperty(value = "分期6期 服务费")
    private BigDecimal period6Fee;

    @ApiModelProperty(value = "分期9期 服务费")
    private BigDecimal period9Fee;

    @ApiModelProperty(value = "分期12期 服务费")
    private BigDecimal period12Fee;

    @ApiModelProperty(value = "创建时间")
    private Date createTime;

    @ApiModelProperty(value = "更新时间")
    private Date updateTime;
}
