package com.zbkj.common.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.List;

/**
 * <b> 个人转账 </b>
 * @author ZXF
 * @create 2023/07/31 0031 11:21
 * @version
 * @注意事项 </b>
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value="JsPayTransferDto", description="个人转账")
public class JsPayTransferDto implements Serializable {

    @ApiModelProperty(value = "账户状态")
    private String accountStatus;
    @ApiModelProperty(value = "用户联合ID")
    private String uniId;
    @ApiModelProperty(value = "入账方")
    private String inId;
    @ApiModelProperty(value = "出账方（退款用）")
    private String outId;

    @ApiModelProperty(value = "原业务交易流水号")
    private String oldBusinessPartnerSeq;
    @ApiModelProperty(value = "业务交易流水号")
    private String businessPartnerSeq;
    @ApiModelProperty(value = "业务编码")
    private String businessCode;

    @ApiModelProperty(value = "订单金额")
    private String amount;

    @ApiModelProperty(value = "备注")
    private String comment;

    @ApiModelProperty(value = "开始时间")
    private String startTime;

    @ApiModelProperty(value = "结束时间")
    private String endTime;

    @ApiModelProperty(value = "商品描述")
    private String goodsDesc;
    @ApiModelProperty(value = "交易类型：04冻结，05解冻")
    private String tradeType;
    @ApiModelProperty(value = "销售分账优先级 0-平台 1-商户")
    private Integer sellFeePriority;
    @ApiModelProperty(value = "平台分账金额")
    private String platAmount;
    @ApiModelProperty(value = "聚合正扫微信拓展参数集合")
    private WxData wxData;
    @ApiModelProperty(value = "支付宝扩展参数集合")
    private AlipayData alipayData;

}
