package com.zbkj.service.wangshang.notify.service.impl;


import com.zbkj.common.constants.Constants;
import com.zbkj.common.dto.HuifuWalletAccountDto;
import com.zbkj.common.model.huifu.HuifuWalletAccount;
import com.zbkj.service.config.PaymentChannel;
import com.zbkj.service.dao.HuifuWalletAccountDao;
import com.zbkj.service.service.TransactionLogService;
import com.zbkj.service.wangshang.api.domain.RequestHead;
import com.zbkj.service.wangshang.api.domain.model.notify.MerchantprodMerchAsyncUpdateMerchantNotifyModel;
import com.zbkj.service.wangshang.api.internal.parser.xml.XmlConverter;
import com.zbkj.service.wangshang.api.service.notify.MerchantprodMerchAsyncUpdateMerchantNotifyRequest;
import com.zbkj.service.wangshang.handle.CommomRequstHandle;
import com.zbkj.service.wangshang.notify.service.MybankNotifyService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import javax.annotation.Resource;
import java.util.Date;

/**
 * 商户修改结果通知（异步通知）
 * ant.mybank.merchantprod.merch.async.updateMerchant.notify
 **/
@Service(value = "bkMerchantprodMerchAsyncUpdateMerchantNotifyService")
public class BkMerchantprodMerchAsyncUpdateMerchantNotifyServiceImpl implements MybankNotifyService {

    private static final Logger logger = LoggerFactory.getLogger(BkcloudfundsProtocolWithholdResultNotifyServiceImpl.class);
    @Autowired
    private CommomRequstHandle commomRequstHandle;

    @Resource
    private HuifuWalletAccountDao huifuWalletAccountDao;
    @Autowired
    TransactionLogService transactionLogService;

    @Override
    public String notifyHandle(String context, String function) throws Exception {
        logger.info("========= > 商户修改结果通知（异步通知）:ant.mybank.merchantprod.merch.async.updateMerchant.notify");
        logger.info("========= > 请求报文："+context);
        //通知内容转换
        MerchantprodMerchAsyncUpdateMerchantNotifyRequest merchantprodMerchAsyncUpdateMerchantNotifyRequest =
                XmlConverter.getInstance().toResponse(context, MerchantprodMerchAsyncUpdateMerchantNotifyRequest.class);
        RequestHead head = merchantprodMerchAsyncUpdateMerchantNotifyRequest.getMerchantprodMerchAsyncUpdateMerchantNotify().getRequestHead();
        boolean flag = false;
        try {
            //通知内容保存
            flag = saveNotify(merchantprodMerchAsyncUpdateMerchantNotifyRequest.getMerchantprodMerchAsyncUpdateMerchantNotify().getMerchantprodMerchAsyncUpdateMerchantNotifyModel());
        }catch (Exception e){
            logger.error("========= > 商户修改结果通知（异步通知）:ant.mybank.merchantprod.merch.async.updateMerchant.notify:"+e.getMessage());
        }
        //响应结果根据执行结果统一处理
        String response = commomRequstHandle.getSignResult(flag, head);
        transactionLogService.save("商户修改结果通知（异步通知）:ant.mybank.merchantprod.merch.async.updateMerchant.notify", Constants.Y, context,response, PaymentChannel.WANGSHANG.toString());
        return response;
    }

    private boolean saveNotify(MerchantprodMerchAsyncUpdateMerchantNotifyModel model) {
        //TODO
        HuifuWalletAccountDto dto = huifuWalletAccountDao.getHuifuWalletAccountByWalletNo(model.getMerchantId());
        if(dto == null){
            return false;
        }
        Date now = new Date();
        HuifuWalletAccount hwa = huifuWalletAccountDao.selectById(dto.getId());
        String status = model.getStatus();

        hwa.setUpdateTime(now);
        if("1".equals(status)){
            hwa.setAcctStat("N");//如果激活通知状态为N正常
            hwa.setFailReason("");
        }else if("2".equals(status)){
            hwa.setAcctStat("F");//如果激活通知状态为N正常
            hwa.setFailReason(model.getFailReason());
        }
        huifuWalletAccountDao.updateById(hwa);
        return true;
    }

}
