package com.zbkj.service.wangshang.api.internal.parser.xml;

import com.zbkj.service.wangshang.api.MybankApiException;
import com.zbkj.service.wangshang.api.MybankApiExceptionEnum;
import com.zbkj.service.wangshang.api.MybankResponse;
import com.zbkj.service.wangshang.api.internal.mapping.Converter;
import com.zbkj.service.wangshang.api.internal.util.JaxbUtil;
import com.zbkj.service.wangshang.api.internal.util.XmlUtils;

/**
 * XML格式转换器
 */
public class XmlConverter implements Converter {

    private XmlConverter() {
    }

    public static XmlConverter getInstance() {
        return XmlConverterInstance.instance;
    }

    private static class XmlConverterInstance {

        static XmlConverter instance = new XmlConverter();

    }

    @Override
    public <T extends MybankResponse> T toResponse(String responseXml, Class<T> clazz) throws MybankApiException {
        if (!XmlUtils.isXmlDocument(responseXml))
            throw new MybankApiException(MybankApiExceptionEnum.NOT_XML_TYPE);
        return getModelFromXML(responseXml, clazz);
    }

    private <T> T getModelFromXML(String responseXml, Class<T> clazz) throws MybankApiException {
        return JaxbUtil.converyToJavaBean(responseXml, clazz);
    }
}