package com.zbkj.service.wangshang.api.domain.model;

import com.zbkj.service.wangshang.api.domain.RespInfo;
import com.zbkj.service.wangshang.api.internal.util.CDataAdapter;
import com.zbkj.service.wangshang.api.MybankObject;

import javax.xml.bind.annotation.*;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;

/**
 * 单笔提现查询接口（异步接口）<ant.mybank.bkcloudfunds.withdraw.query>
 * 响应模型
 */
@XmlAccessorType(XmlAccessType.FIELD)
@XmlRootElement(name = "body")
public class BkcloudfundsWithdrawQueryResponseModel extends MybankObject {

    private static final long serialVersionUID = -9027000096742817059L;
    /**
     * 返回码组件
     */
    @XmlElementRef
    private RespInfo respInfo;

    /**
     * 提现商户号
     * <p>
     * 网商为商户分配的商户号，通过商户入驻结果查询接口获取。
     */
    @XmlJavaTypeAdapter(CDataAdapter.class)
    @XmlElement(name = "MerchantId")
    private String merchantId;

    /**
     * 外部订单分账请求流水号
     * <P>
     * 由合作方生成，同笔交易，交易状态未明需要重试时，使用同一个交易号。
     */
    @XmlJavaTypeAdapter(CDataAdapter.class)
    @XmlElement(name = "OutTradeNo")
    private String outTradeNo;

    /**
     * 网商提现订单号
     */
    @XmlJavaTypeAdapter(CDataAdapter.class)
    @XmlElement(name = "OrderNo")
    private String orderNo;

    /**
     * 提现总金额（单位：分）
     */
    @XmlJavaTypeAdapter(CDataAdapter.class)
    @XmlElement(name = "TotalAmount")
    private String totalAmount;

    /**
     * 币种
     */
    @XmlJavaTypeAdapter(CDataAdapter.class)
    @XmlElement(name = "Currency")
    private String currency;

    /**
     * 平台设置提现手续费用（银行控制盖帽比率），用户实收资金= TotalAmount - PlatformFee
     */
    @XmlJavaTypeAdapter(CDataAdapter.class)
    @XmlElement(name = "PlatformFee")
    private String platformFee;

    /**
     * 币种
     */
    @XmlJavaTypeAdapter(CDataAdapter.class)
    @XmlElement(name = "FeeCurrency")
    private String feeCurrency;

    /**
     * 状态，状态(SUCCESS,DEALING ，FAIL)
     */
    @XmlJavaTypeAdapter(CDataAdapter.class)
    @XmlElement(name = "Status")
    private String status;

    /**
     * 绑定银行卡号
     */
    @XmlJavaTypeAdapter(CDataAdapter.class)
    @XmlElement(name = "BankCardNo")
    private String bankCardNo;

    /**
     * 绑卡卡号户名
     */
    @XmlJavaTypeAdapter(CDataAdapter.class)
    @XmlElement(name = "BankCertName")
    private String bankCertName;

    /**
     * 提现时间
     */
    @XmlJavaTypeAdapter(CDataAdapter.class)
    @XmlElement(name = "WithdrawApplyDate")
    private String withdrawApplyDate;

    /**
     * 提现完成时间
     */
    @XmlJavaTypeAdapter(CDataAdapter.class)
    @XmlElement(name = "WithdrawFinishDate")
    private String withdrawFinishDate;

    /**
     * 备注
     */
    @XmlJavaTypeAdapter(CDataAdapter.class)
    @XmlElement(name = "Memo")
    private String memo;

    /**
     * 错误描述
     */
    @XmlJavaTypeAdapter(CDataAdapter.class)
    @XmlElement(name = "ErrorDesc")
    private String errorDesc;

    public RespInfo getRespInfo() {
        return respInfo;
    }

    public void setRespInfo(RespInfo respInfo) {
        this.respInfo = respInfo;
    }

    public String getMerchantId() {
        return merchantId;
    }

    public void setMerchantId(String merchantId) {
        this.merchantId = merchantId;
    }

    public String getOutTradeNo() {
        return outTradeNo;
    }

    public void setOutTradeNo(String outTradeNo) {
        this.outTradeNo = outTradeNo;
    }

    public String getOrderNo() {
        return orderNo;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo;
    }

    public String getTotalAmount() {
        return totalAmount;
    }

    public void setTotalAmount(String totalAmount) {
        this.totalAmount = totalAmount;
    }

    public String getCurrency() {
        return currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency;
    }

    public String getPlatformFee() {
        return platformFee;
    }

    public void setPlatformFee(String platformFee) {
        this.platformFee = platformFee;
    }

    public String getFeeCurrency() {
        return feeCurrency;
    }

    public void setFeeCurrency(String feeCurrency) {
        this.feeCurrency = feeCurrency;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getBankCardNo() {
        return bankCardNo;
    }

    public void setBankCardNo(String bankCardNo) {
        this.bankCardNo = bankCardNo;
    }

    public String getBankCertName() {
        return bankCertName;
    }

    public void setBankCertName(String bankCertName) {
        this.bankCertName = bankCertName;
    }

    public String getWithdrawApplyDate() {
        return withdrawApplyDate;
    }

    public void setWithdrawApplyDate(String withdrawApplyDate) {
        this.withdrawApplyDate = withdrawApplyDate;
    }

    public String getWithdrawFinishDate() {
        return withdrawFinishDate;
    }

    public void setWithdrawFinishDate(String withdrawFinishDate) {
        this.withdrawFinishDate = withdrawFinishDate;
    }

    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }

    public String getErrorDesc() {
        return errorDesc;
    }

    public void setErrorDesc(String errorDesc) {
        this.errorDesc = errorDesc;
    }
}