package com.zbkj.service.wangshang.api.domain.model;

import com.zbkj.service.wangshang.api.MybankObject;
import com.zbkj.service.wangshang.api.domain.RespInfo;
import lombok.Data;

import javax.xml.bind.annotation.*;

/**
 * 账户场景余额查询<ant.mybank.bkcloudfunds.merchant.scene.balance.query>
 */
@Data
@XmlAccessorType(XmlAccessType.FIELD)
@XmlRootElement(name = "body")
public class BkcloudfundsMerchantSceneBalanceQueryResponseModel extends MybankObject {

    private static final long serialVersionUID = -4458455764630354513L;
    /**
     * 返回码组件
     */
    @XmlElementRef
    private RespInfo respInfo;

    /**
     * 合作方机构号（网商银行分配）
     */
    @XmlElement(name = "IsvOrgId")
    private String isvOrgId;

    /**
     * 商户号
     */
    @XmlElement(name = "MerchantId")
    private String merchantId;

    /**
     * 币种
     */
    @XmlElement(name = "Currency")
    private String currency;

    /**
     * 账户余额 JSON数组&Base64编码
     * <p>
     * 例:
     * 返回值包含可提现金额和可支付金额
     * 示例：{"WITHDRAW":"0","PAY":"14900"}表是可以提现0， 可以支付14900分
     */
    @XmlElement(name = "BalanceInfo")
    private String balanceInfo;

    /**
     * 预留扩展字段 Map<String,String>的Json格式 base64编码
     * 例:
     * eyJXSVRIRFJBVyI6IjQ5OTk5NzciLCJQQVkiOiI0OTk5OTc3In0=
     * 解码为:
     * {"WITHDRAW":"4999977","PAY":"4999977"}
     */
    @XmlElement(name = "ExtInfo")
    private String extInfo;
}