package com.zbkj.service.wangshang.api;

import com.zbkj.service.wangshang.api.domain.RequestBody;
import com.zbkj.service.wangshang.api.domain.RequestHead;

public interface MybankRequest<T extends MybankResponse> extends DefaultRequest<T> {

    /**
     * 设置请求路由分组
     *
     * @param cookieValue 路由分组值
     */
    public void setCookieValue(String cookieValue);

    /**
     * 获取当前请求路由分组
     *
     * @return 路由分组值
     */
    public String getCookieValue();

    /**
     * 判断是否需要加签
     *
     * @return
     */
    public boolean isNeedSign();

    /**
     * 设置请求是否需要加签
     *
     * @param needSign
     */
    public void setNeedSign(boolean needSign);

    /**
     * 获取公共请求参数Model
     *
     * @return 公共请求参数Model
     */
    public RequestHead getRequestHead();

    /**
     * 设置公共请求参数Model
     *
     * @param requestHead
     */
    public void setRequestHead(RequestHead requestHead);

    /**
     * 获取业务请求参数Model
     *
     * @return 业务请求参数Model
     */
    public RequestBody getRequestBody();

    /**
     * 设置业务请求参数Model
     *
     * @param requestBody
     */
    public void setRequestBody(RequestBody requestBody);

    /**
     * 构建请求XML报文内容（待签名）
     *
     * @return 请求XML报文内容（待签名）
     */
    public String xmlBuild() throws MybankApiException;
}