package com.zbkj.service.huifu.v2;

import cn.hutool.extra.servlet.ServletUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.huifu.bspay.sdk.opps.core.request.V2TradeOnlinepaymentBankingFrontpayRequest;
import com.huifu.bspay.sdk.opps.core.utils.DateTools;
import com.zbkj.common.utils.RequestUtil;
import com.zbkj.service.huifu.constants.HFProfileConstants;
import com.zbkj.service.huifu.core.Identify;
import org.apache.commons.lang3.StringUtils;

import javax.servlet.http.HttpServletRequest;
import java.util.HashMap;
import java.util.Map;

/**
 * 网银支付接口 - 示例
 *
 * @author sdk-generator
 * @Description
 */
@Identify(requestClass = V2TradeOnlinepaymentBankingFrontpayRequest.class)
public class V2TradeOnlinepaymentBankingFrontpay {

    public static V2TradeOnlinepaymentBankingFrontpayRequest method(Map<String, Object> map) {

        // 2.组装请求参数
        V2TradeOnlinepaymentBankingFrontpayRequest request = JSONObject.parseObject(JSON.toJSONString(map),V2TradeOnlinepaymentBankingFrontpayRequest.class);
//        V2TradeOnlinepaymentBankingFrontpayRequest request = new V2TradeOnlinepaymentBankingFrontpayRequest();
        // 请求流水号
//        request.setReqSeqId(SequenceTools.getReqSeqId32());
        // 请求日期
        request.setReqDate(DateTools.getCurrentDateYYYYMMDD());
        // 商户号
        request.setHuifuId(HFProfileConstants.HUIFU_ID);
        // 订单金额
//        request.setTransAmt("0.02");
        // 商品描述
//        request.setGoodsDesc("网银支付下单");
        // 网联扩展数据
        request.setExtendPayData(getExtendPayData(map));
        // 设备信息
        request.setTerminalDeviceData(getTerminalDeviceData());
        // 安全信息
        request.setRiskCheckData(getRiskCheckData());
        // 异步通知地址
//        request.setNotifyUrl("http://www.chinapnr.com");

        // 设置非必填字段
        Map<String, Object> extendInfoMap = getExtendInfos(map);
        request.setExtendInfo(extendInfoMap);
        return request;
    }

    /**
     * 非必填字段
     * @return
     */
    private static Map<String, Object> getExtendInfos(Map<String, Object> map) {
        // 设置非必填字段
        Map<String, Object> extendInfoMap = new HashMap<>();
        // 收款汇付账户号
        extendInfoMap.put("acct_id", "");
        // 订单类型
        extendInfoMap.put("order_type", map.get("orderType"));
        // 卡类型
        extendInfoMap.put("card_type", "D");
        // 订单失效时间
        extendInfoMap.put("time_expire", "");
        // 网关支付类型
        extendInfoMap.put("gate_type", "02");
        // 付款方银行编号
        extendInfoMap.put("bank_id", map.get("bankId"));
        // 延时标记
        extendInfoMap.put("delay_acct_flag", "N");
        //分账商户号如果跟平台商户号不一致才做分账
        if(!HFProfileConstants.HUIFU_ID.equals(map.get("acctId"))){
            // 分账对象
            extendInfoMap.put("acct_split_bunch", getAcctSplitBunchRucan(map));
        }
        // 备注
        extendInfoMap.put("remark", map.get("goodsDesc"));
        // 页面跳转地址
        extendInfoMap.put("front_url", map.get("frontUrl"));
        // 手续费扣款标志
        // extendInfoMap.put("fee_flag", "");
        return extendInfoMap;
    }

    private static String getExtendPayData(Map<String, Object> map) {
        JSONObject dto = new JSONObject();
        // 商品简称
        dto.put("goods_short_name", map.get("goodsDesc"));
        // 网关支付受理渠道
        dto.put("gw_chnnl_tp", "01");
        // 业务种类
        dto.put("biz_tp", "200000");

        return dto.toJSONString();
    }

    private static String getTerminalDeviceData() {

        //客户IP获取
        String clientIP = "127.0.0.1";
        try{
            HttpServletRequest request = RequestUtil.getRequest();
            clientIP = ServletUtil.getClientIP(request, null);
        }catch (Exception e){}

        JSONObject dto = new JSONObject();
        // 交易设备类型
        dto.put("device_type", "4");
        // 交易设备IP
        dto.put("device_ip", clientIP);
        // 交易设备MAC
        // dto.put("device_mac", "");
        // 交易终端设备IMEI
        // dto.put("device_imei", "");
        // 交易设备IMSI
        // dto.put("device_imsi", "");
        // 交易设备ICCID
        // dto.put("device_icc_id", "");
        // 交易设备WIFIMAC
        // dto.put("device_wifi_mac", "");
        // 交易设备GPS
        // dto.put("device_gps", "");

        return dto.toJSONString();
    }

    private static JSON getAcctInfos(Map<String, Object> map) {
        JSONArray dtoList = new JSONArray();
        //要扣手续费的情况，先分8块给到平台商户
        if(!String.valueOf(map.get("divAmt")).equals(String.valueOf(map.get("transAmt")))){
            JSONObject pdto = new JSONObject();
            // 分账金额
            pdto.put("div_amt",HFProfileConstants.RECHARGE_HANDLING_FEE_MIN);
            // 被分账方ID
            pdto.put("huifu_id", HFProfileConstants.HUIFU_ID);
            // 被分账户号
            // dto.put("acct_id", "");

            dtoList.add(pdto);
        }
        JSONObject dto = new JSONObject();
        // 分账金额
        dto.put("div_amt", map.get("divAmt"));
        // 被分账方ID
        dto.put("huifu_id", map.get("acctId"));
        // 被分账户号
        // dto.put("acct_id", "");

        dtoList.add(dto);
        return dtoList;
    }

    private static String getAcctSplitBunchRucan(Map<String, Object> map) {
        JSONObject dto = new JSONObject();
        // 分账明细
         dto.put("acct_infos", getAcctInfos(map));

        return dto.toJSONString();
    }

    private static String getRiskCheckData() {

        //客户IP获取
        String clientIP = "127.0.0.1";
        try{
            HttpServletRequest request = RequestUtil.getRequest();
            clientIP = ServletUtil.getClientIP(request, null);
        }catch (Exception e){}

        JSONObject dto = new JSONObject();
        // ip地址
        dto.put("ip_addr", clientIP);
        // 基站地址
        dto.put("base_station", "");
        // 纬度
        dto.put("latitude", "");
        // 经度
        dto.put("longitude", "");

        return dto.toJSONString();
    }

}
