/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.impl;

import cn.binarywang.wx.miniapp.api.WxMaService;
import cn.binarywang.wx.miniapp.bean.live.WxMaLiveGoodInfo;
import cn.binarywang.wx.miniapp.bean.live.WxMaLiveResult;
import cn.hutool.core.util.ObjectUtil;
import cn.hutool.core.util.URLUtil;
import com.alibaba.fastjson.JSON;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.PageHelper;
import com.zbkj.common.enums.WechatMPLiveGoodsReviewStatusEnum;
import com.zbkj.common.exception.CrmebException;
import com.zbkj.common.exception.weixin.CRMEBWxError;
import com.zbkj.common.model.admin.SystemAdmin;
import com.zbkj.common.model.merchant.Merchant;
import com.zbkj.common.model.wechat.live.WechatLiveGoods;
import com.zbkj.common.request.PageParamRequest;
import com.zbkj.common.request.wxmplive.goods.WechatLiveGoodsAddRequest;
import com.zbkj.common.request.wxmplive.goods.WechatLiveGoodsEditRequest;
import com.zbkj.common.request.wxmplive.goods.WechatLiveGoodsSearchRequest;
import com.zbkj.common.utils.SecurityUtil;
import com.zbkj.service.dao.wechat.live.WechatLiveGoodsDao;
import com.zbkj.service.service.MerchantService;
import com.zbkj.service.service.SystemAttachmentService;
import com.zbkj.service.service.WechatLiveGoodsService;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import me.chanjar.weixin.common.enums.WxType;
import me.chanjar.weixin.common.error.WxErrorException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WechatLiveGoodsServiceImpl
extends ServiceImpl<WechatLiveGoodsDao, WechatLiveGoods>
implements WechatLiveGoodsService {
    private static final Logger logger = LoggerFactory.getLogger(WechatLiveGoodsServiceImpl.class);
    @Resource
    private WechatLiveGoodsDao dao;
    @Autowired
    private WxMaService wxMaService;
    @Autowired
    private MerchantService merchantService;
    @Autowired
    private SystemAttachmentService systemAttachmentService;

    @Override
    public List<WechatLiveGoods> getList(WechatLiveGoodsSearchRequest request, PageParamRequest pageParamRequest, Boolean isMer) {
        PageHelper.startPage((int)pageParamRequest.getPage(), (int)pageParamRequest.getLimit());
        LambdaQueryWrapper lambdaQueryWrapper = Wrappers.lambdaQuery();
        if (ObjectUtil.isNotEmpty((Object)request.getKeywords())) {
            String decodeKeywords = URLUtil.decode((String)request.getKeywords());
            ((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)lambdaQueryWrapper.eq(WechatLiveGoods::getId, (Object)decodeKeywords)).or()).eq(WechatLiveGoods::getProductId, (Object)decodeKeywords)).or()).like(WechatLiveGoods::getName, (Object)decodeKeywords)).or()).like(WechatLiveGoods::getGoodsId, (Object)decodeKeywords)).or()).like(WechatLiveGoods::getAuditId, (Object)decodeKeywords)).or()).like(WechatLiveGoods::getMerName, (Object)decodeKeywords);
        }
        if (ObjectUtil.isNotEmpty((Object)request.getReviewStatus())) {
            lambdaQueryWrapper.eq(WechatLiveGoods::getReviewStatus, (Object)request.getReviewStatus());
        }
        if (ObjectUtil.isNotEmpty((Object)request.getMerchant_type())) {
            lambdaQueryWrapper.eq(WechatLiveGoods::getMerType, (Object)request.getMerchant_type());
        }
        if (isMer.booleanValue()) {
            lambdaQueryWrapper.eq(WechatLiveGoods::getMerId, (Object)SecurityUtil.getLoginUserVo().getUser().getMerId());
        }
        ((LambdaQueryWrapper)lambdaQueryWrapper.orderByDesc(WechatLiveGoods::getSort)).orderByDesc(WechatLiveGoods::getId);
        return this.dao.selectList((Wrapper)lambdaQueryWrapper);
    }

    @Override
    public Boolean platReview(Integer id, Integer reviewStatus, String reviewReason) {
        WechatLiveGoods wechatLiveGoods = (WechatLiveGoods)this.dao.selectById(id);
        try {
            if (ObjectUtil.isEmpty((Object)wechatLiveGoods)) {
                throw new CrmebException("\u5f85\u5ba1\u6838\u5546\u54c1\u672a\u627e\u5230");
            }
            if (WechatMPLiveGoodsReviewStatusEnum.PLAT_REVIEW_ERROR.getCode().equals(reviewStatus) && ObjectUtil.isEmpty((Object)reviewReason)) {
                throw new CrmebException("\u5e73\u53f0\u5ba1\u6838\u5931\u8d25\u539f\u56e0\u4e0d\u80fd\u4e3a\u7a7a");
            }
            wechatLiveGoods.setReviewStatus(reviewStatus);
            wechatLiveGoods.setReviewReason(reviewReason);
            if (reviewStatus.equals(WechatMPLiveGoodsReviewStatusEnum.PLAT_REVIEW_ERROR.getCode())) {
                this.dao.updateById(wechatLiveGoods);
            } else {
                WxMaLiveGoodInfo wxMaLiveGoodInfo = new WxMaLiveGoodInfo();
                BeanUtils.copyProperties((Object)wechatLiveGoods, (Object)wxMaLiveGoodInfo);
                WxMaLiveResult wxMaLiveResult = this.wxMaService.getLiveGoodsService().addGoods(wxMaLiveGoodInfo);
                logger.info("\u5546\u54c1\u5ba1\u6838\u7ed3\u679c:{}", (Object)JSON.toJSONString((Object)wxMaLiveResult));
                if (ObjectUtil.isNotNull((Object)wxMaLiveResult.getAuditId())) {
                    wechatLiveGoods.setGoodsId(wxMaLiveResult.getGoodsId());
                    wechatLiveGoods.setAuditId(wxMaLiveResult.getAuditId());
                    wechatLiveGoods.setReviewStatus(WechatMPLiveGoodsReviewStatusEnum.PLAT_REVIEW_SUCCESS.getCode());
                } else {
                    wechatLiveGoods.setReviewStatus(WechatMPLiveGoodsReviewStatusEnum.WECHAT_REVIEW_ERROR.getCode());
                    wechatLiveGoods.setReviewReason("\u5fae\u4fe1\u5ba1\u6838\u4e0d\u901a\u8fc7");
                    logger.error("\u5fae\u4fe1\u5ba1\u6838\u76f4\u64ad\u5546\u54c1\u5931\u8d25\u539f\u56e0:{}", (Object)JSON.toJSONString((Object)wechatLiveGoods));
                }
                this.dao.updateById(wechatLiveGoods);
            }
            return true;
        }
        catch (WxErrorException e) {
            CRMEBWxError crmebWxError = CRMEBWxError.fromJson((String)e.getError().getJson(), (WxType)WxType.Open);
            wechatLiveGoods.setReviewStatus(WechatMPLiveGoodsReviewStatusEnum.WECHAT_REVIEW_ERROR.getCode());
            wechatLiveGoods.setReviewReason(crmebWxError.getErrmsg());
            this.dao.updateById(wechatLiveGoods);
            throw new CrmebException("\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u76f4\u64ad - \u5e73\u53f0\u63d0\u5ba1\uff01" + crmebWxError.getErrmsg());
        }
    }

    @Override
    public WechatLiveGoods getByAuditId(Integer auditId) {
        LambdaQueryWrapper lambdaQueryWrapper = Wrappers.lambdaQuery();
        lambdaQueryWrapper.eq(WechatLiveGoods::getAuditId, (Object)auditId);
        return (WechatLiveGoods)this.dao.selectOne((Wrapper)lambdaQueryWrapper);
    }

    @Override
    public List<WechatLiveGoods> getByGoodsId(List<Integer> goodsIds) {
        LambdaQueryWrapper lambdaQueryWrapper = Wrappers.lambdaQuery();
        lambdaQueryWrapper.in(WechatLiveGoods::getGoodsId, goodsIds);
        return this.dao.selectList((Wrapper)lambdaQueryWrapper);
    }

    @Override
    public String merchantAuditGoods(Integer id) {
        try {
            WechatLiveGoods liveGoods = (WechatLiveGoods)this.dao.selectById(id);
            if (!liveGoods.getReviewStatus().equals(WechatMPLiveGoodsReviewStatusEnum.PLAT_REVIEW_SUCCESS.getCode())) {
                throw new CrmebException("\u76f4\u64ad\u5546\u54c1\u5e76\u975e\u5fae\u4fe1\u5ba1\u6838\u4e2d \u4e0d\u80fd\u6267\u884c\u91cd\u65b0\u63d0\u4ea4\u5ba1\u6838\u64cd\u4f5c");
            }
            String auditId = this.wxMaService.getLiveGoodsService().auditGoods(liveGoods.getGoodsId());
            if (ObjectUtil.isEmpty((Object)auditId)) {
                throw new CrmebException("\u91cd\u65b0\u63d0\u4ea4\u5546\u54c1\u5ba1\u6838\u5931\u8d25");
            }
            liveGoods.setAuditId(Long.valueOf(auditId));
            this.dao.updateById(liveGoods);
        }
        catch (WxErrorException e) {
            logger.error("\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u76f4\u64ad - \u91cd\u65b0\u63d0\u4ea4\u5546\u54c1\u5931\u8d25 {}", (Object)e.getError());
            throw new CrmebException("\u91cd\u65b0\u63d0\u4ea4\u5546\u54c1\u5ba1\u6838\u5931\u8d25" + CRMEBWxError.fromJson((String)e.getError().getJson(), (WxType)WxType.Open));
        }
        return null;
    }

    @Override
    public Boolean merchantResetAudit(Integer id) {
        try {
            WechatLiveGoods wechatLiveGoods = (WechatLiveGoods)this.dao.selectById(id);
            if (!wechatLiveGoods.getReviewStatus().equals(WechatMPLiveGoodsReviewStatusEnum.PLAT_REVIEW_SUCCESS.getCode())) {
                throw new CrmebException("\u76f4\u64ad\u5546\u54c1\u72b6\u6001\u5e76\u975e\u5fae\u4fe1\u5ba1\u6838\u4e2d \u4e0d\u80fd\u6267\u884c\u64a4\u56de\u64cd\u4f5c");
            }
            boolean auditResult = this.wxMaService.getLiveGoodsService().resetAudit(Integer.valueOf(wechatLiveGoods.getAuditId().toString()), wechatLiveGoods.getGoodsId());
            if (!auditResult) {
                throw new CrmebException("\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u76f4\u64ad\u5546\u54c1 \u64a4\u56de\u5ba1\u6838\u5931\u8d25");
            }
            wechatLiveGoods.setReviewStatus(WechatMPLiveGoodsReviewStatusEnum.CREATED.getCode());
            return this.dao.updateById(wechatLiveGoods) > 0;
        }
        catch (WxErrorException e) {
            logger.error("\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u76f4\u64ad - \u64a4\u56de\u5546\u54c1\u5ba1\u6838 {}", (Object)e.getError());
            throw new CrmebException("\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u76f4\u64ad - \u64a4\u56de\u5546\u54c1\u5ba1\u6838\uff01" + CRMEBWxError.fromJson((String)e.getError().getJson(), (WxType)WxType.Open));
        }
    }

    @Override
    public void getGoodsWareHouse() {
        logger.info("\u76f4\u64ad\u5546\u54c1 - \u66f4\u65b0\u76f4\u64ad\u5546\u54c1\u72b6\u6001START");
        try {
            LambdaQueryWrapper wrapperQuery = Wrappers.lambdaQuery();
            wrapperQuery.eq(WechatLiveGoods::getReviewStatus, (Object)WechatMPLiveGoodsReviewStatusEnum.PLAT_REVIEW_SUCCESS.getCode());
            List wechatLiveGoodsList = this.dao.selectList((Wrapper)wrapperQuery);
            logger.info("\u76f4\u64ad\u5546\u54c1 - \u5f85\u66f4\u65b0\u7684\u5546\u54c1:{}", (Object)JSON.toJSONString((Object)wechatLiveGoodsList));
            List goodsIds = wechatLiveGoodsList.stream().map(WechatLiveGoods::getGoodsId).distinct().collect(Collectors.toList());
            logger.info("\u76f4\u64ad\u5546\u54c1 - \u8c03\u7528\u5fae\u4fe1\u66f4\u65b0\u53c2\u6570:{}", goodsIds);
            WxMaLiveResult goodsWareHouse = this.wxMaService.getLiveGoodsService().getGoodsWareHouse(goodsIds);
            logger.info("\u76f4\u64ad\u5546\u54c1 - \u8c03\u7528\u5fae\u4fe1\u66f4\u65b0\u7ed3\u679c:{}", (Object)JSON.toJSONString((Object)goodsWareHouse));
            for (WechatLiveGoods wechatLiveGoods : wechatLiveGoodsList) {
                List collect = goodsWareHouse.getGoods().stream().filter(goods -> goods.getGoodsId().equals(wechatLiveGoods.getGoodsId())).collect(Collectors.toList());
                WxMaLiveResult.Goods good = (WxMaLiveResult.Goods)collect.get(0);
                wechatLiveGoods.setAuditStatus(good.getAuditStatus());
                wechatLiveGoods.setThirdPartyTag(Integer.valueOf(good.getThirdPartyTag()));
                wechatLiveGoods.setThirdPartyAppid(good.getThirdPartyAppid());
                wechatLiveGoods.setReviewStatus(WechatMPLiveGoodsReviewStatusEnum.WECHAT_REVIEW_SUCCESS.getCode());
            }
            this.updateBatchById(wechatLiveGoodsList);
        }
        catch (WxErrorException e) {
            logger.error("\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u76f4\u64ad - \u83b7\u53d6\u5546\u54c1\u7684\u4fe1\u606f\u4e0e\u5ba1\u6838\u72b6\u6001 {}", (Object)e.getError());
            throw new CrmebException("\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u76f4\u64ad - \u83b7\u53d6\u5546\u54c1\u7684\u4fe1\u606f\u4e0e\u5ba1\u6838\u72b6\u6001\uff01" + CRMEBWxError.fromJson((String)e.getError().getJson(), (WxType)WxType.Open));
        }
        logger.info("\u76f4\u64ad\u5546\u54c1 - \u66f4\u65b0\u76f4\u64ad\u5546\u54c1\u72b6\u6001END");
    }

    @Override
    public Boolean addGoods(List<WechatLiveGoodsAddRequest> requests) {
        SystemAdmin currentUser = SecurityUtil.getLoginUserVo().getUser();
        Merchant currentMerchantInfo = this.merchantService.getByIdException(currentUser.getMerId());
        ArrayList<WechatLiveGoods> wechatLiveGoodsList = new ArrayList<WechatLiveGoods>();
        for (WechatLiveGoodsAddRequest request : requests) {
            WechatLiveGoods wechatLiveGoods = new WechatLiveGoods();
            BeanUtils.copyProperties((Object)request, (Object)wechatLiveGoods);
            logger.info("\u76f4\u64ad\u5546\u54c1 - \u6dfb\u52a0:request:{}", (Object)JSON.toJSONString((Object)request));
            wechatLiveGoods.setReviewStatus(WechatMPLiveGoodsReviewStatusEnum.BEFORE_REVIEW.getCode());
            wechatLiveGoods.setMerName(currentMerchantInfo.getName());
            wechatLiveGoods.setMerType(currentMerchantInfo.getTypeId());
            wechatLiveGoods.setMerId(currentMerchantInfo.getId());
            wechatLiveGoods.setCoverImgUrlLocal(this.systemAttachmentService.clearPrefix(wechatLiveGoods.getCoverImgUrlLocal()));
            logger.info("\u76f4\u64ad\u5546\u54c1 - \u6dfb\u52a0:wechatLiveGoods:{}", (Object)JSON.toJSONString((Object)wechatLiveGoods));
            wechatLiveGoodsList.add(wechatLiveGoods);
        }
        logger.info("\u76f4\u64ad\u5546\u54c1 - \u6700\u7ec8\u65b0\u589e\u7684:wechatLiveGoodsList:{}", (Object)JSON.toJSONString(wechatLiveGoodsList));
        return this.saveBatch(wechatLiveGoodsList);
    }

    @Override
    public Boolean updateGoods(WechatLiveGoodsEditRequest goods) {
        try {
            WechatLiveGoods currentWechatLiveGoods = (WechatLiveGoods)this.dao.selectById(goods.getId());
            WxMaLiveGoodInfo wxMaLiveGoodInfo = new WxMaLiveGoodInfo();
            BeanUtils.copyProperties((Object)goods, (Object)wxMaLiveGoodInfo);
            if (currentWechatLiveGoods.getReviewStatus().equals(WechatMPLiveGoodsReviewStatusEnum.WECHAT_REVIEW_SUCCESS.getCode())) {
                wxMaLiveGoodInfo.setGoodsId(currentWechatLiveGoods.getGoodsId());
                logger.info("\u7f16\u8f91\u76f4\u64ad\u95f4\u5546\u54c1\u53c2\u6570:{}", (Object)JSON.toJSONString((Object)wxMaLiveGoodInfo));
                boolean updateResult = this.wxMaService.getLiveGoodsService().updateGoods(wxMaLiveGoodInfo);
                if (updateResult) {
                    logger.info("\u7f16\u8f91\u76f4\u64ad\u5546\u54c1\u6210\u529f:{}", (Object)JSON.toJSONString((Object)currentWechatLiveGoods));
                } else {
                    logger.info("\u7f16\u8f91\u76f4\u64ad\u5546\u54c1\u5931\u8d25:{}", (Object)JSON.toJSONString((Object)currentWechatLiveGoods));
                }
            }
            WechatLiveGoods localWechatLiveGoods = new WechatLiveGoods();
            BeanUtils.copyProperties((Object)goods, (Object)localWechatLiveGoods);
            logger.info("\u7f16\u8f91\u76f4\u64ad\u5546\u54c1:goods:{}", (Object)JSON.toJSONString((Object)goods));
            localWechatLiveGoods.setReviewReason(null).setReviewStatus(WechatMPLiveGoodsReviewStatusEnum.BEFORE_REVIEW.getCode());
            localWechatLiveGoods.setCoverImgUrlLocal(this.systemAttachmentService.clearPrefix(localWechatLiveGoods.getCoverImgUrlLocal()));
            logger.info("\u7f16\u8f91\u76f4\u64ad\u5546\u54c1:localWechatLiveGoods:{}", (Object)JSON.toJSONString((Object)localWechatLiveGoods));
            return this.dao.updateById(localWechatLiveGoods) > 0;
        }
        catch (WxErrorException e) {
            logger.error("\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u76f4\u64ad - \u66f4\u65b0\u5546\u54c1 {}", (Object)e.getError());
            throw new CrmebException("\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u76f4\u64ad - \u66f4\u65b0\u5546\u54c1\uff01" + CRMEBWxError.fromJson((String)e.getError().getJson(), (WxType)WxType.Open));
        }
    }

    @Override
    public Boolean updateSort(Integer id, Integer sort) {
        WechatLiveGoods wechatLiveGoods = new WechatLiveGoods().setId(id).setSort(sort);
        return this.dao.updateById(wechatLiveGoods) > 0;
    }

    @Override
    public WxMaLiveResult getApprovedGoods(PageParamRequest pageParamRequest, Integer status) {
        try {
            return this.wxMaService.getLiveGoodsService().getApprovedGoods(Integer.valueOf(pageParamRequest.getPage()), Integer.valueOf(pageParamRequest.getLimit()), status);
        }
        catch (WxErrorException e) {
            logger.error("\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u76f4\u64ad - \u83b7\u53d6\u5546\u54c1\u5217\u8868 {}", (Object)e.getError());
            throw new CrmebException("\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u76f4\u64ad - \u83b7\u53d6\u5546\u54c1\u5217\u8868\uff01" + CRMEBWxError.fromJson((String)e.getError().getJson(), (WxType)WxType.Open));
        }
    }

    @Override
    public Boolean deleteGoods(Integer id) {
        try {
            WechatLiveGoods wechatLiveGoods = (WechatLiveGoods)this.dao.selectById(id);
            if (!wechatLiveGoods.getReviewStatus().equals(WechatMPLiveGoodsReviewStatusEnum.WECHAT_REVIEW_SUCCESS.getCode())) {
                return this.dao.deleteById(id) > 0;
            }
            boolean deleteResult = this.wxMaService.getLiveGoodsService().deleteGoods(wechatLiveGoods.getGoodsId());
            if (!deleteResult) {
                throw new CrmebException("\u5220\u9664\u5fae\u4fe1\u76f4\u64ad\u5546\u54c1\u5931\u8d25:");
            }
            return this.dao.deleteById(id) > 0;
        }
        catch (WxErrorException e) {
            logger.error("\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u76f4\u64ad - \u5220\u9664\u5546\u54c1 {}", (Object)e.getError());
            throw new CrmebException("\u5fae\u4fe1\u5c0f\u7a0b\u5e8f\u76f4\u64ad - \u5220\u9664\u5546\u54c1\uff01" + CRMEBWxError.fromJson((String)e.getError().getJson(), (WxType)WxType.Open));
        }
    }
}

