package com.zbkj.common.response.bcx;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;
import java.io.Serializable;
import java.util.Date;
import java.math.BigDecimal;

/**
 * 订单线下支付响应对象
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@ApiModel(value = "BcxPayOfflineResponse对象", description = "订单线下支付响应对象")
public class BcxPayOfflineResponse implements Serializable {
    private static final long serialVersionUID=1L;

    @ApiModelProperty(value = "线下支付id")
    private Integer id;

    @ApiModelProperty(value = "订单号")
    private String orderNo;

    @ApiModelProperty(value = "0-待支付 1-待确认 2-已确认 3已到款")
    private Integer status;

    @ApiModelProperty(value = "用户支付说明")
    private String userMsg;

    @ApiModelProperty(value = "下单时间")
    private Date orderTime;

    @ApiModelProperty(value = "支付方式:offline 线下支付")
    private String payType;

    @ApiModelProperty(value = "实际支付金额")
    private BigDecimal payPrice;

    @ApiModelProperty(value = "赠送积分")
    private Integer gainIntegral;

    @ApiModelProperty(value = "收款户名")
    private String bankUserName;

    @ApiModelProperty(value = "收款银行")
    private String bankName;

    @ApiModelProperty(value = "银行卡号")
    private String bankCard;
}
