package com.zbkj.common.request.bcx;

import com.alibaba.excel.annotation.ExcelProperty;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;

/**
 * 订单设备编号导入请求对象
 */
@Data
@EqualsAndHashCode(callSuper = false)
@ApiModel(value = "BcxOrderNoImportRequest对象", description = "订单设备编号导入请求对象")
public class BcxOrderNoImportRequest implements Serializable {
    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "订单号", required = true)
    @ExcelProperty(value = "订单号",index = 0)
    private String orderNo;

    @ApiModelProperty(value = "设备编号", required = true)
    @ExcelProperty(value = "设备编号", index = 1)
    private String deviceNo;
}
