package com.zbkj.common.model.order;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;
import lombok.experimental.Accessors;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * <b> 虚拟订单（体检业务用） </b>
 * @author ZXF
 * @create 2025/08/25 0025 16:07
 * @version
 * @注意事项 </b>
 */
@Data
@EqualsAndHashCode(callSuper = false)
@Accessors(chain = true)
@TableName("eb_virtual_order")
@ApiModel(value = "VirtualOrder对象", description = "虚拟订单表")
public class VirtualOrder implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(value = "主键")
    @TableId(value = "id", type = IdType.AUTO)
    private Integer id;

    @ApiModelProperty(value = "虚拟订单号")
    private String virtualOrderNo;

    @ApiModelProperty(value = "商户ID")
    private Integer merId;

    @ApiModelProperty(value = "用户id")
    private Integer uid;

    @ApiModelProperty(value = "商品ID")
    private Integer productId;

    @ApiModelProperty(value = "商品名称")
    private String productName;

    @ApiModelProperty(value = "商品规格值 ID")
    private Integer attrValueId;

    @ApiModelProperty(value = "商品sku")
    private String sku;

    @ApiModelProperty(value = "商品类型：0-实体, 1-虚拟, 2-特殊(考培), 3-保险, 4-风评等等")
    private Integer bizType;

    @ApiModelProperty(value = "业务类型子分类：1-对讲机、2-执法记录仪、0-其他")
    private Integer bizSubType;

    @ApiModelProperty(value = "商品单价")
    private BigDecimal price;

    @ApiModelProperty(value = "购买数量")
    private Integer payNum;

    @ApiModelProperty(value = "订单总额")
    private BigDecimal totalPrice;

    @ApiModelProperty(value = "成交数量")
    private Integer dealNum;

    @ApiModelProperty(value = "退款数量")
    private Integer refundNum;

    @ApiModelProperty(value = "订单创建请求源数据jsonstring")
    private String createOrderRequest;

    @ApiModelProperty(value = "订单预处理源数据jsonstring")
    private String preOrderInfoVo;
    @ApiModelProperty(value = "订单预处理源数据固化分账配置jsonstring")
    private String platFeeConfig;

    @ApiModelProperty(value = "创建时间")
    private Date createTime;

    @ApiModelProperty(value = "更新时间")
    private Date updateTime;

    @ApiModelProperty(value = "订单状态（0：待支付, 1：已支付, 6：已完成）")
    private Integer status = 0;

    @ApiModelProperty(value = "源头业务编号,目前有考培的sourceId和风评的sourceId")
    private String sourceId;
}
