/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.common.config;

import java.util.Arrays;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.boot.info.GitProperties;
import org.springframework.context.ConfigurableApplicationContext;

public class GitConfig {
    private static final Logger log = LoggerFactory.getLogger(GitConfig.class);

    public static void printGitInfo(ConfigurableApplicationContext context) {
        try {
            if (log.isInfoEnabled()) {
                GitProperties gitProperties = (GitProperties)context.getBean(GitProperties.class);
                log.info("========== BCX.MALL Git\u7248\u672c ==========");
                log.info("===== git origin url: {}", (Object)gitProperties.get("remote.origin.url"));
                log.info("===== git branch: {}", (Object)gitProperties.get("branch"));
                log.info("===== git commit id: {}", (Object)gitProperties.get("commit.id.full"));
                log.info("===== git commit user: {}", (Object)(gitProperties.get("commit.user.name") + "<" + gitProperties.get("commit.user.email") + ">"));
                log.info("===== git commit time: {}", (Object)gitProperties.get("commit.time"));
                log.info("===== git commit message: {}", (Object)gitProperties.get("commit.message.full"));
                String dirty = gitProperties.get("dirty");
                if ("true".equalsIgnoreCase(dirty)) {
                    log.warn("===== git dirty: {}", (Object)dirty);
                } else {
                    log.info("===== git dirty: {}", (Object)dirty);
                }
                log.info("===== git build time: {}", (Object)gitProperties.get("build.time"));
                log.info("===== git build host: {}", (Object)gitProperties.get("build.host"));
                Object[] activeProfiles = context.getEnvironment().getActiveProfiles();
                if (activeProfiles.length > 0) {
                    log.info("===== active profiles: {}", (Object)Arrays.toString(activeProfiles));
                } else {
                    log.info("===== no active profiles ");
                }
                log.info("========== BCX.MALL \u542f\u52a8\u5b8c\u6210 ==========");
            }
        }
        catch (NoSuchBeanDefinitionException e) {
            log.warn(e.getMessage());
        }
    }
}

