package com.zbkj.admin.controller.platform;

import com.zbkj.common.response.BcxDepartmentResponse;
import com.zbkj.common.result.CommonResult;
import com.zbkj.service.service.BcxDepartmentService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

import java.util.List;

/**
 * description: 部门表 控制层
 * author : linchunpeng
 * date : 2023/8/3
 */
@Slf4j
@Api(tags = "分销系统-部门表控制层")
@RestController
@RequestMapping("/api/admin/platform/bcx/department")
public class BcxDepartmentController {
    
    @Autowired
    private BcxDepartmentService bcxDepartmentService;


//    @PreAuthorize("hasAuthority('platform:retail:store:config:save')")
    @ApiOperation(value = "获取部门tree列表")
    @RequestMapping(value = "/tree", method = RequestMethod.GET)
    public CommonResult<List<BcxDepartmentResponse>> findAllTree() {
        return CommonResult.success(bcxDepartmentService.findAllTree());
    }
    
}