/*
 * Decompiled with CFR 0.152.
 */
package com.zbkj.service.service.bcx;

import cn.hutool.core.collection.CollUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.github.pagehelper.PageInfo;
import com.zbkj.common.exception.CrmebException;
import com.zbkj.common.model.bcx.BcxPlatformFee;
import com.zbkj.common.model.bcx.BcxPlatformFeeConfig;
import com.zbkj.common.model.order.Order;
import com.zbkj.common.model.order.OrderDetail;
import com.zbkj.common.page.CommonPage;
import com.zbkj.common.request.PageParamRequest;
import com.zbkj.service.dao.bcx.BcxPlatformFeeDao;
import com.zbkj.service.service.OrderDetailService;
import com.zbkj.service.service.OrderService;
import com.zbkj.service.service.bcx.BcxPlatformFeeConfigService;
import com.zbkj.service.service.bcx.BcxPlatformFeeService;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class BcxPlatformFeeServiceImpl
extends ServiceImpl<BcxPlatformFeeDao, BcxPlatformFee>
implements BcxPlatformFeeService {
    @Resource
    private BcxPlatformFeeDao dao;
    @Resource
    private BcxPlatformFeeConfigService bcxPlatformFeeConfigService;
    @Resource
    private OrderService orderService;
    @Resource
    private OrderDetailService orderDetailService;

    @Override
    public BcxPlatformFee queryById(Integer id) {
        BcxPlatformFee source = (BcxPlatformFee)this.dao.selectById(id);
        BcxPlatformFee target = this.transform(source);
        return target;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public BcxPlatformFee queryByOrderNo(String orderNo, Integer orderType) {
        LambdaQueryWrapper lqw = new LambdaQueryWrapper();
        lqw.eq(BcxPlatformFee::getOrderNo, (Object)orderNo);
        lqw.eq(BcxPlatformFee::getOrderType, (Object)orderType);
        lqw.orderByDesc(BcxPlatformFee::getId);
        lqw.last("limit 1");
        BcxPlatformFee fee = (BcxPlatformFee)this.dao.selectOne((Wrapper)lqw);
        if (fee == null) {
            Order order = this.orderService.getByOrderNo(orderNo);
            OrderDetail orderDetail = this.orderDetailService.getByOrderNo(orderNo).get(0);
            BcxPlatformFeeConfig platFeeConfig = this.bcxPlatformFeeConfigService.queryByAnyId(order.getMerId(), orderDetail.getProductId(), 0);
            if (platFeeConfig == null) {
                throw new CrmebException("\u5e73\u53f0\u670d\u52a1\u8d39\u914d\u7f6e\u4e0d\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u5ba2\u670d");
            }
            BigDecimal platformFee = this.bcxPlatformFeeConfigService.calcSellPlatformFee(platFeeConfig, order.getPayPrice(), orderDetail.getPayNum());
            fee = BcxPlatformFee.builder().orderType(orderType).orderNo(orderNo).platFee(platformFee).config(JSONObject.toJSONString((Object)platFeeConfig)).transPriority(platFeeConfig.getSellFeePriority()).build();
            this.save(fee);
        }
        return fee;
    }

    @Override
    public PageInfo<BcxPlatformFee> queryPagedList(BcxPlatformFee request, PageParamRequest pageParamRequest) {
        LambdaQueryWrapper lqw = new LambdaQueryWrapper();
        lqw.eq(BcxPlatformFee::getId, (Object)request.getId());
        lqw.orderByDesc(BcxPlatformFee::getId);
        Page page = PageHelper.startPage((int)pageParamRequest.getPage(), (int)pageParamRequest.getLimit());
        List sources = this.dao.selectList((Wrapper)lqw);
        if (CollUtil.isEmpty((Collection)sources)) {
            return CommonPage.copyPageInfo((Page)page, (List)CollUtil.newArrayList((Object[])new BcxPlatformFee[0]));
        }
        List<BcxPlatformFee> result = this.transform(sources);
        return CommonPage.copyPageInfo((Page)page, result);
    }

    private List<BcxPlatformFee> transform(List<BcxPlatformFee> sources) {
        ArrayList<BcxPlatformFee> result = new ArrayList<BcxPlatformFee>();
        for (BcxPlatformFee source : sources) {
            BcxPlatformFee target = this.transform(source);
            result.add(target);
        }
        return result;
    }

    private BcxPlatformFee transform(BcxPlatformFee source) {
        BcxPlatformFee target = new BcxPlatformFee();
        BeanUtils.copyProperties((Object)source, (Object)target);
        return target;
    }
}

