/*
 * Decompiled with CFR 0.152.
 */
package com.bcxin.auth.framework.web.exception;

import com.bcxin.auth.common.core.domain.AjaxResult;
import com.bcxin.auth.common.exception.BusinessException;
import com.bcxin.auth.common.exception.DemoModeException;
import com.bcxin.auth.common.exception.V5BusinessException;
import com.bcxin.auth.common.utils.ServletUtils;
import com.bcxin.auth.common.utils.security.PermissionUtils;
import javax.servlet.http.HttpServletRequest;
import org.apache.shiro.authz.AuthorizationException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.BindException;
import org.springframework.validation.ObjectError;
import org.springframework.web.HttpRequestMethodNotSupportedException;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RestControllerAdvice;
import org.springframework.web.servlet.ModelAndView;

@RestControllerAdvice
public class GlobalExceptionHandler {
    private static final Logger log = LoggerFactory.getLogger(GlobalExceptionHandler.class);

    @ExceptionHandler(value={AuthorizationException.class})
    public Object handleAuthorizationException(HttpServletRequest request, AuthorizationException e) {
        log.error(e.getMessage(), (Throwable)e);
        if (ServletUtils.isAjaxRequest((HttpServletRequest)request)) {
            return AjaxResult.error((String)PermissionUtils.getMsg((String)e.getMessage()));
        }
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.setViewName("error/unauth");
        return modelAndView;
    }

    @ExceptionHandler(value={HttpRequestMethodNotSupportedException.class})
    public AjaxResult handleException(HttpRequestMethodNotSupportedException e) {
        log.error(e.getMessage(), (Throwable)e);
        return AjaxResult.error((String)("\u4e0d\u652f\u6301' " + e.getMethod() + "'\u8bf7\u6c42"));
    }

    @ExceptionHandler(value={RuntimeException.class})
    public AjaxResult notFount(RuntimeException e) {
        log.error("\u8fd0\u884c\u65f6\u5f02\u5e38:", (Throwable)e);
        return AjaxResult.error((String)("\u8fd0\u884c\u65f6\u5f02\u5e38:" + e.getMessage()));
    }

    @ExceptionHandler(value={Exception.class})
    public AjaxResult handleException(Exception e) {
        log.error(e.getMessage(), (Throwable)e);
        return AjaxResult.error((String)"\u670d\u52a1\u5668\u9519\u8bef\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458");
    }

    @ExceptionHandler(value={V5BusinessException.class})
    public Object V5BusinessException(V5BusinessException e) {
        log.error(e.getMessage(), (Throwable)e);
        return AjaxResult.error((String)e.getMessage());
    }

    @ExceptionHandler(value={BusinessException.class})
    public Object businessException(HttpServletRequest request, BusinessException e) {
        log.error(e.getMessage(), (Throwable)e);
        if (ServletUtils.isAjaxRequest((HttpServletRequest)request)) {
            return AjaxResult.error((String)e.getMessage());
        }
        ModelAndView modelAndView = new ModelAndView();
        modelAndView.addObject("errorMessage", (Object)e.getMessage());
        modelAndView.setViewName("error/business");
        return modelAndView;
    }

    @ExceptionHandler(value={BindException.class})
    public AjaxResult validatedBindException(BindException e) {
        log.error(e.getMessage(), (Throwable)e);
        String message = ((ObjectError)e.getAllErrors().get(0)).getDefaultMessage();
        return AjaxResult.error((String)message);
    }

    @ExceptionHandler(value={DemoModeException.class})
    public AjaxResult demoModeException(DemoModeException e) {
        return AjaxResult.error((String)"\u6f14\u793a\u6a21\u5f0f\uff0c\u4e0d\u5141\u8bb8\u64cd\u4f5c");
    }
}

