package com.bcxin.statistics.service.v5;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bcxin.statistics.dao.mapper.TlkEventProjectMapper;
import com.bcxin.statistics.entity.TlkEventProjectEntity;
import com.bcxin.statistics.entity.TlkEventTeamEntity;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

/**
 * description：智能人事-项目表
 * author：linchunpeng
 * date：2024/12/31
 */
@Slf4j
@Service
public class TlkEventProjectService extends ServiceImpl<TlkEventProjectMapper, TlkEventProjectEntity> {

    /**
     * description：根据组织id，查询项目列表
     * author：linchunpeng
     * date：2025/4/27
     */
    public List<TlkEventProjectEntity> getByOrdId(String orgId) {
        LambdaQueryChainWrapper<TlkEventProjectEntity> lqw = this.lambdaQuery();
        lqw.eq(TlkEventProjectEntity::getItemDomainId, orgId);
        List<TlkEventProjectEntity> list = lqw.list();
        if (CollectionUtil.isNotEmpty(list)) {
            return list;
        }
        return new ArrayList<>();
    }

}