package com.bcxin.statistics.service.v5;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bcxin.statistics.dao.mapper.TlkAttendanceSiteBaseInfoMapper;
import com.bcxin.statistics.entity.TlkAttendanceSiteBaseInfoEntity;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * description：智能人事-驻勤点表
 * author：linchunpeng
 * date：2024/12/31
 */
@Slf4j
@Service
public class TlkAttendanceSiteBaseInfoService extends ServiceImpl<TlkAttendanceSiteBaseInfoMapper, TlkAttendanceSiteBaseInfoEntity> {

    /**
     * description：根据组织id，获取驻勤点列表
     * author：linchunpeng
     * date：2025/1/9
     */
    public List<TlkAttendanceSiteBaseInfoEntity> getByProjectIdAndOrgIdList(String projectId, List<String> orgIdList) {
        LambdaQueryChainWrapper<TlkAttendanceSiteBaseInfoEntity> lqw = this.lambdaQuery();
        lqw.eq(TlkAttendanceSiteBaseInfoEntity::getItemProjectId, projectId);
        lqw.in(TlkAttendanceSiteBaseInfoEntity::getDomainid, orgIdList);
        lqw.isNotNull(TlkAttendanceSiteBaseInfoEntity::getItemAttendanceSiteName);
        return lqw.list();
    }

}