package com.bcxin.statistics.service.v5;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bcxin.statistics.dao.mapper.ExternalMembersMapper;
import com.bcxin.statistics.entity.ExternalMembersEntity;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

/**
 * description：智能人事-分组成员表
 * author：linchunpeng
 * date：2024/12/31
 */
@Slf4j
@Service
public class ExternalMembersService extends ServiceImpl<ExternalMembersMapper, ExternalMembersEntity> {

    /**
     * description：判断是不是团队负责人
     * author：linchunpeng
     * date：2025/1/6
     */
    public boolean isAdminByOrgIdAndEmployeeId(String orgId, String employeeId) {
        LambdaQueryChainWrapper<ExternalMembersEntity> lqw = this.lambdaQuery();
        lqw.eq(ExternalMembersEntity::getReferenceNumber, orgId);
        lqw.eq(ExternalMembersEntity::getId, employeeId);
        lqw.eq(ExternalMembersEntity::getMemberType, 0);
        lqw.eq(ExternalMembersEntity::getApprovedInformationStatus, 1);
        return lqw.exists();
    }

}