package com.bcxin.statistics.service.statistics;

import cn.hutool.core.collection.CollectionUtil;
import com.bcxin.statistics.common.utils.PageUtils;
import com.bcxin.statistics.dao.mapper.SaiYanStatisticsMapper;
import com.bcxin.statistics.dtos.request.EmptyRequest;
import com.bcxin.statistics.dtos.request.SaiYanStatisticsRequest;
import com.bcxin.statistics.dtos.request.SaiYanStatisticsSiteRequest;
import com.bcxin.statistics.dtos.request.SaiYanStatisticsTeamRequest;
import com.bcxin.statistics.dtos.response.statistics.SaiYanAttendanceStatisticsResponse;
import com.bcxin.statistics.dtos.response.statistics.SaiYanSignInStatisticsResponse;
import com.bcxin.statistics.entity.TlkAttendanceSiteBaseInfoEntity;
import com.bcxin.statistics.entity.TlkEventProjectEntity;
import com.bcxin.statistics.entity.TlkEventTeamEntity;
import com.bcxin.statistics.service.v5.TlkAttendanceSiteBaseInfoService;
import com.bcxin.statistics.service.v5.TlkEventProjectService;
import com.bcxin.statistics.service.v5.TlkEventTeamService;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;
import java.util.stream.Collectors;

/**
 * description：赛演统计
 * author：linchunpeng
 * date：2025/4/25
 */
@Slf4j
@Service
public class SaiYanStatisticsService {

    @Autowired
    private SaiYanStatisticsMapper saiYanStatisticsMapper;
    @Autowired
    private TlkAttendanceSiteBaseInfoService attendanceSiteBaseInfoService;
    @Autowired
    private TlkEventProjectService tlkEventProjectService;
    @Autowired
    private TlkEventTeamService tlkEventTeamService;


    /**
     * description：赛演考勤统计-项目列表
     * author：linchunpeng
     * date：2025/4/27
     */
    public List<TlkEventProjectEntity>  getSyAttendanceStatisticsProject(EmptyRequest request) {
        List<TlkEventProjectEntity> list1 = tlkEventProjectService.getByOrdId(request.getOrgId());
        List<TlkEventProjectEntity> list2 = tlkEventTeamService.getProjectListByOrgId(request.getOrgId());
        List<TlkEventProjectEntity> result = new ArrayList<>();
        if (CollectionUtil.isNotEmpty(list1)) {
            for (TlkEventProjectEntity projectEntity : list1) {
                if (result.stream().noneMatch(project -> project.getId().equals(projectEntity.getId()))) {
                    result.add(projectEntity);
                }
            }
        }
        if (CollectionUtil.isNotEmpty(list2)) {
            for (TlkEventProjectEntity projectEntity : list2) {
                if (result.stream().noneMatch(project -> project.getId().equals(projectEntity.getId()))) {
                    result.add(projectEntity);
                }
            }
        }
        return result;
    }

    /**
     * description：赛演考勤统计-团队列表
     * author：linchunpeng
     * date：2025/4/27
     */
    public List<TlkEventTeamEntity> getSyAttendanceStatisticsTeam(SaiYanStatisticsTeamRequest request) {
        TlkEventProjectEntity projectEntity = tlkEventProjectService.getById(request.getProjectId());
        if (projectEntity != null) {
            if (!projectEntity.getItemDomainId().equals(request.getOrgId())) {
                //不是活动承办方，只能看自己
                return tlkEventTeamService.getTeamByProjectIdOrTeamIdList(request.getProjectId(), Collections.singletonList(request.getOrgId()));
            } else {
                return tlkEventTeamService.getTeamByProjectIdOrTeamIdList(request.getProjectId(), null);
            }
        }
        return new ArrayList<>();
    }

    /**
     * description：赛演考勤统计-考勤组（岗点）列表
     * author：linchunpeng
     * date：2025/4/27
     */
    public List<TlkAttendanceSiteBaseInfoEntity> getSyAttendanceStatisticsSite(SaiYanStatisticsSiteRequest request) {
        return attendanceSiteBaseInfoService.getByProjectIdAndOrgIdList(request.getProjectId(), request.getTeamIdList());
    }

    /**
     * description：赛演考勤统计
     * author：linchunpeng
     * date：2025/4/25
     */
    public List<SaiYanAttendanceStatisticsResponse> syAttendanceStatistics(SaiYanStatisticsRequest request) {
        //判断是活动承办方 或者 团队组织
        TlkEventProjectEntity projectEntity = tlkEventProjectService.getById(request.getProjectId());
        if (projectEntity != null) {
            if (!projectEntity.getItemDomainId().equals(request.getOrgId())) {
                //不是活动承办方，只能看自己
                request.setTeamIdList(Collections.singletonList(request.getOrgId()));
            }
            //根据项目id，查询团队列表
            List<TlkEventTeamEntity> teamEntityList = tlkEventTeamService.getTeamByProjectIdOrTeamIdList(request.getProjectId(), request.getTeamIdList());
            //根据团队列表，查询驻勤点列表
            if (CollectionUtil.isNotEmpty(teamEntityList)) {
                List<String> orgIdList = teamEntityList.stream().map(TlkEventTeamEntity::getItemTeamId).collect(Collectors.toList());
                List<TlkAttendanceSiteBaseInfoEntity> attendanceSiteEntityList = attendanceSiteBaseInfoService.getByProjectIdAndOrgIdList(request.getProjectId(), orgIdList);
                //根据驻勤点列表，查询统计结果
                if (CollectionUtil.isNotEmpty(attendanceSiteEntityList)) {
                    List<String> siteIdList = attendanceSiteEntityList.stream().map(TlkAttendanceSiteBaseInfoEntity::getId).collect(Collectors.toList());
                    Map<String, Object> paramMap = new HashMap<>();
                    paramMap.put("userName", request.getUserName());
                    paramMap.put("siteIdList", CollectionUtil.isNotEmpty(request.getSiteIdList()) ? request.getSiteIdList() : siteIdList);
                    paramMap.put("statisticsStartTime", request.getStatisticsStartTime());
                    paramMap.put("statisticsEndTime", request.getStatisticsEndTime());
                    PageUtils.startPage(request);//分页
                    List<SaiYanAttendanceStatisticsResponse> statisticsResponseList = saiYanStatisticsMapper.selectAttendanceStatistics(paramMap);
                    //往上汇总统计结果
                    if (CollectionUtil.isNotEmpty(statisticsResponseList)) {
                        Set<Long> entids = statisticsResponseList.stream().map(SaiYanAttendanceStatisticsResponse::getEntid).collect(Collectors.toSet());
                        paramMap.put("entids", entids);
                        //先查询分页的企业汇总
                        List<SaiYanAttendanceStatisticsResponse> totalStatisticsResponseList = saiYanStatisticsMapper.selectAttendanceStatisticsByEntids(paramMap);
                        Map<String, SaiYanAttendanceStatisticsResponse> teamTotalStatisticsMap = new HashMap<>();
                        for (SaiYanAttendanceStatisticsResponse response : totalStatisticsResponseList) {
                            String key = response.getStatisticsDate().concat("_").concat(response.getEntid().toString());
                            SaiYanAttendanceStatisticsResponse result = teamTotalStatisticsMap.get(key);
                            if (result == null) {
                                result = new SaiYanAttendanceStatisticsResponse();
                            }
                            if (response.getShouldClockInCount().intValue() == response.getActualClockInCount().intValue()
                                    && response.getLateCount() == 0
                                    && response.getLeaveEarlyCount() == 0) {
                                //正常
                                result.addNormalPeopleNumber();
                            } else {
                                //异常
                                result.addAbnormalPeopleNumber();
                                if (response.getLateCount() > 0) {
                                    //迟到
                                    result.addLatePeopleNumber();
                                }
                                if (response.getLeaveEarlyCount() > 0) {
                                    //早退
                                    result.addLeaveEarlyPeopleNumber();
                                }
                            }
                            teamTotalStatisticsMap.put(key, result);
                        }
                        for (SaiYanAttendanceStatisticsResponse response : statisticsResponseList) {
                            String key = response.getStatisticsDate().concat("_").concat(response.getEntid().toString());
                            SaiYanAttendanceStatisticsResponse total = teamTotalStatisticsMap.get(key);
                            response.setProjectName(projectEntity.getItemProjectName());
                            if (total != null) {
                                response.setNormalPeopleNumber(total.getNormalPeopleNumber());
                                response.setAbnormalPeopleNumber(total.getAbnormalPeopleNumber());
                                response.setLatePeopleNumber(total.getLatePeopleNumber());
                                response.setLeaveEarlyPeopleNumber(total.getLeaveEarlyPeopleNumber());
                            }
                        }
                        return statisticsResponseList;
                    }
                }
            }
        }
        return new ArrayList<>();
    }


    /**
     * description：赛演签到统计
     * author：linchunpeng
     * date：2025/4/27
     */
    public List<SaiYanSignInStatisticsResponse> sySignInStatistics(SaiYanStatisticsRequest request) {
//判断是活动承办方 或者 团队组织
        TlkEventProjectEntity projectEntity = tlkEventProjectService.getById(request.getProjectId());
        if (projectEntity != null) {
            if (!projectEntity.getItemDomainId().equals(request.getOrgId())) {
                //不是活动承办方，只能看自己
                request.setTeamIdList(Collections.singletonList(request.getOrgId()));
            }
            Map<String, Object> paramMap = new HashMap<>();
            paramMap.put("projectId", request.getProjectId());
            paramMap.put("teamIdList", request.getTeamIdList());
            paramMap.put("operateType", request.getOperateType());
            paramMap.put("userName", request.getUserName());
            paramMap.put("siteIdList", request.getSiteIdList());
            paramMap.put("statisticsStartTime", request.getStatisticsStartTime());
            paramMap.put("statisticsEndTime", request.getStatisticsEndTime());
            PageUtils.startPage(request);//分页
            List<SaiYanSignInStatisticsResponse> statisticsResponseList = saiYanStatisticsMapper.selectSignInStatistics(paramMap);
            if (CollectionUtil.isNotEmpty(statisticsResponseList)) {
                List<String> employeeIds = statisticsResponseList.stream().map(SaiYanSignInStatisticsResponse::getEmployeeId).collect(Collectors.toList());
                paramMap.put("employeeIds", employeeIds);
                //查询分页的企业汇总
                List<SaiYanSignInStatisticsResponse> totalStatisticsResponseList = saiYanStatisticsMapper.selectSignInStatisticsByEmployeeIds(paramMap);
                Map<String, Integer> employeeSignInCountMap = new HashMap<>();
                for (SaiYanSignInStatisticsResponse response : totalStatisticsResponseList) {
                    String key = response.getStatisticsDate().concat("_").concat(response.getEmployeeId())
                            .concat("_").concat(response.getSiteName()).concat("_").concat(response.getOperateType());
                    Integer result = employeeSignInCountMap.get(key);
                    if (result == null) {
                        result = 0;
                    }
                    result++;
                    employeeSignInCountMap.put(key, result);
                }
                for (SaiYanSignInStatisticsResponse response : statisticsResponseList) {
                    String key = response.getStatisticsDate().concat("_").concat(response.getEmployeeId())
                            .concat("_").concat(response.getSiteName()).concat("_").concat(response.getOperateType());
                    Integer result = employeeSignInCountMap.get(key);
                    if (result == null) {
                        result = 0;
                    }
                    response.setOperateCount(result);
                }
                return statisticsResponseList;
            }
        }
        return new ArrayList<>();
    }
}
