package com.bcxin.statistics.dtos.response.statistics;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;


@Data
@ApiModel(value = "SaiYanAttendanceStatisticsResponse对象", description = "赛演考勤统计response对象")
public class SaiYanAttendanceStatisticsResponse {

    @ApiModelProperty(value = "项目名称")
    private String projectName;
    @ApiModelProperty(value = "统计日期")
    private String statisticsDate;
    @ApiModelProperty(value = "团队组织名称")
    private String teamName;
    @ApiModelProperty(value = "陀螺匠企业id")
    private Long entid;
    @ApiModelProperty(value = "正常人数")
    private Integer normalPeopleNumber;
    @ApiModelProperty(value = "异常人数")
    private Integer abnormalPeopleNumber;
    @ApiModelProperty(value = "迟到人数")
    private Integer latePeopleNumber;
    @ApiModelProperty(value = "早退人数")
    private Integer leaveEarlyPeopleNumber;
    @ApiModelProperty(value = "考勤组")
    private String groupName;
    @ApiModelProperty(value = "姓名")
    private String userName;
    @ApiModelProperty(value = "班次")
    private String shiftName;
    @ApiModelProperty(value = "应打卡次数")
    private Integer shouldClockInCount;
    @ApiModelProperty(value = "实际打卡次数")
    private Integer actualClockInCount;
    @ApiModelProperty(value = "迟到次数")
    private Integer lateCount;
    @ApiModelProperty(value = "早退次数")
    private Integer leaveEarlyCount;
    @ApiModelProperty(value = "缺卡次数")
    private Integer missingCount;
    @ApiModelProperty(value = "应出勤时长（小时）")
    private Double shouldAttendanceTime;
    @ApiModelProperty(value = "实际出勤时长（小时）")
    private Double actualAttendanceTime;
    @ApiModelProperty(value = "加班时长（小时）")
    private Double workOvertime;
    @ApiModelProperty(value = "请假时长（小时）")
    private Double leaveTime;

    public void addNormalPeopleNumber() {
        if (normalPeopleNumber == null) {
            normalPeopleNumber = 0;
        }
        normalPeopleNumber++;
    }

    public void addAbnormalPeopleNumber() {
        if (abnormalPeopleNumber == null) {
            abnormalPeopleNumber = 0;
        }
        abnormalPeopleNumber++;;
    }

    public void addLatePeopleNumber() {
        if (latePeopleNumber == null) {
            latePeopleNumber = 0;
        }
        latePeopleNumber++;;
    }

    public void addLeaveEarlyPeopleNumber() {
        if (leaveEarlyPeopleNumber == null) {
            leaveEarlyPeopleNumber = 0;
        }
        leaveEarlyPeopleNumber++;;
    }

    public Integer getNormalPeopleNumber() {
        if (normalPeopleNumber == null) {
            return 0;
        }
        return normalPeopleNumber;
    }

    public Integer getAbnormalPeopleNumber() {
        if (abnormalPeopleNumber == null) {
            return 0;
        }
        return abnormalPeopleNumber;
    }

    public Integer getLatePeopleNumber() {
        if (latePeopleNumber == null) {
            return 0;
        }
        return latePeopleNumber;
    }

    public Integer getLeaveEarlyPeopleNumber() {
        if (leaveEarlyPeopleNumber == null) {
            return 0;
        }
        return leaveEarlyPeopleNumber;
    }
}
