package com.bcxin.statistics.dtos.response.result;

import com.bcxin.statistics.common.emus.StatusCode;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import lombok.Getter;

/**
 * 统一错误返回结果
 */
@JsonPropertyOrder({"code", "msg", "timestamp"})
public class ErrorRespResult extends AbstractRespResult {
    /**
     * 调试信息
     */
    @Getter
    /**
     * 注解不返回控制，避免debugMsg不开启的时候返回控制
     */
    @JsonInclude(JsonInclude.Include.NON_NULL)
    private String debugMsg;

    public ErrorRespResult(int code, String message) {
        super(code, message);
    }

    public ErrorRespResult(int code, String message, String debugMsg) {
        super(code, message);
        if (debugMsg == null) {
            this.debugMsg = "";
        } else {
            this.debugMsg = debugMsg;
        }
    }

    protected ErrorRespResult(StatusCode statusCode, String message) {
        super(statusCode, message);
    }

    public ErrorRespResult(StatusCode statusCode, String message, String debugMsg) {
        super(statusCode, message);
        if (debugMsg == null) {
            this.debugMsg = "";
        } else {
            this.debugMsg = debugMsg;
        }
    }

    /**
     * 获取错误信息，包括错误明细信息
     */
    public static final ErrorRespResult fail(int code, String errorMessage) {
        return new ErrorRespResult(code, errorMessage);
    }

    /**
     * 获取错误信息，包括错误明细信息 这个方法用于调试模块
     */
    public static final ErrorRespResult fail(int code, String errorMessage, String debugMsg) {
        return new ErrorRespResult(code, errorMessage, debugMsg);
    }

    /**
     * 获取错误信息，包括错误明细信息
     */
    public static final ErrorRespResult fail(StatusCode statusCode, String errorMessage) {
        return new ErrorRespResult(statusCode, errorMessage);
    }

    /**
     * 获取错误信息，包括错误明细信息 这个方法用于调试模块
     */
    public static final ErrorRespResult fail(StatusCode statusCode, String errorMessage, String debugMsg) {
        return new ErrorRespResult(statusCode, errorMessage, debugMsg);
    }
}
