package com.bcxin.statistics.dtos.request;

import com.bcxin.statistics.common.utils.StringUtils;
import com.bcxin.statistics.dtos.page.PageDomain;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import javax.validation.constraints.NotBlank;
import java.util.List;


@Data
@ApiModel(value = "SaiYanStatisticsRequest对象", description = "赛演考勤统计request对象")
public class SaiYanStatisticsRequest extends PageDomain {

    @ApiModelProperty(value = "项目id", required = true)
    @NotBlank(message = "项目id不能为空")
    private String projectId;

    @ApiModelProperty(value = "团队组织id，数组")
    private List<String> teamIdList;

    @ApiModelProperty(value = "考勤组（岗点）id，数组")
    private List<String> siteIdList;

    @ApiModelProperty(value = "姓名")
    private String userName;

    @ApiModelProperty(value = "统计开始时间，yyyy-MM-dd")
    private String statisticsStartTime;

    @ApiModelProperty(value = "统计结束时间，yyyy-MM-dd")
    private String statisticsEndTime;


    @ApiModelProperty(value = "操作类型(签到统计)，0：签到，1：签退")
    private Integer operateType;


    @ApiModelProperty(hidden = true)
    private String userId;
    @ApiModelProperty(hidden = true)
    private String orgId;
    @ApiModelProperty(hidden = true)
    private String empId;

    public String getStatisticsStartTime() {
        if (StringUtils.isNotEmpty(statisticsStartTime)) {
            return statisticsStartTime.concat(" 00:00:00");
        }
        return null;
    }

    public String getStatisticsEndTime() {
        if (StringUtils.isNotEmpty(statisticsEndTime)) {
            return statisticsEndTime.concat(" 23:59:59");
        }
        return null;
    }
}
