package com.bcxin.statistics.controller;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.statistics.common.utils.ExcelMergeUtil;
import com.bcxin.statistics.common.utils.ExportUtil;
import com.bcxin.statistics.dtos.page.TableDataInfo;
import com.bcxin.statistics.dtos.request.EmptyRequest;
import com.bcxin.statistics.dtos.request.SaiYanStatisticsRequest;
import com.bcxin.statistics.dtos.request.SaiYanStatisticsSiteRequest;
import com.bcxin.statistics.dtos.request.SaiYanStatisticsTeamRequest;
import com.bcxin.statistics.dtos.response.statistics.SaiYanAttendanceStatisticsResponse;
import com.bcxin.statistics.dtos.response.statistics.SaiYanSignInStatisticsResponse;
import com.bcxin.statistics.dtos.response.statistics.excel.SaiYanAttendanceStatisticsExcel;
import com.bcxin.statistics.dtos.response.statistics.excel.SaiYanSignInStatisticsExcel;
import com.bcxin.statistics.entity.TlkAttendanceSiteBaseInfoEntity;
import com.bcxin.statistics.entity.TlkEventProjectEntity;
import com.bcxin.statistics.entity.TlkEventTeamEntity;
import com.bcxin.statistics.service.statistics.SaiYanStatisticsService;
import com.github.pagehelper.PageInfo;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.validation.annotation.Validated;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RestController;

import javax.servlet.http.HttpServletResponse;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

/**
 * description：赛演统计
 * author：linchunpeng
 * date：2025/4/25
 */
@Slf4j
@Api(tags = "赛演统计")
@RestController
public class SaiYanStatisticsController extends BaseController {

    @Autowired
    private SaiYanStatisticsService saiYanStatisticsService;

    @ApiOperation(value = "赛演统计-项目列表")
    @PostMapping("/api/sy/statistics/project")
    public List<TlkEventProjectEntity> syStatisticsProject(@RequestBody @Validated EmptyRequest request){
        log.info("赛演考勤统计-项目列表，参数：{}", JSONObject.toJSONString(request));
        return saiYanStatisticsService.getSyAttendanceStatisticsProject(request);
    }


    @ApiOperation(value = "赛演统计-团队列表")
    @PostMapping("/api/sy/statistics/team")
    public List<TlkEventTeamEntity> syStatisticsTeam(@RequestBody @Validated SaiYanStatisticsTeamRequest request){
        log.info("赛演考勤统计-团队列表，参数：{}", JSONObject.toJSONString(request));
        return saiYanStatisticsService.getSyAttendanceStatisticsTeam(request);
    }


    @ApiOperation(value = "赛演统计-考勤组（岗点）列表")
    @PostMapping("/api/sy/statistics/site")
    public List<TlkAttendanceSiteBaseInfoEntity> syStatisticsSite(@RequestBody @Validated SaiYanStatisticsSiteRequest request){
        log.info("赛演考勤统计-考勤组（岗点）列表，参数：{}", JSONObject.toJSONString(request));
        return saiYanStatisticsService.getSyAttendanceStatisticsSite(request);
    }

    @ApiOperation(value = "赛演考勤统计")
    @PostMapping("/api/sy/statistics/attendance")
    public TableDataInfo<SaiYanAttendanceStatisticsResponse> syStatisticsAttendance(@RequestBody @Validated SaiYanStatisticsRequest request){
        log.info("赛演统计，参数：{}", JSONObject.toJSONString(request));
        List<SaiYanAttendanceStatisticsResponse> list = saiYanStatisticsService.syAttendanceStatistics(request);
        return new TableDataInfo<>(list, new PageInfo<>(list).getTotal());
    }

    @ApiOperation(value = "赛演签到统计")
    @PostMapping("/api/sy/statistics/sign/in")
    public TableDataInfo<SaiYanSignInStatisticsResponse> syStatisticsSignIn(@RequestBody @Validated SaiYanStatisticsRequest request){
        log.info("赛演签到统计，参数：{}", JSONObject.toJSONString(request));
        List<SaiYanSignInStatisticsResponse> list = saiYanStatisticsService.sySignInStatistics(request);
        return new TableDataInfo<>(list, new PageInfo<>(list).getTotal());
    }

    @ApiOperation(value = "赛演考勤统计-导出excel")
    @PostMapping(value = "/api/sy/statistics/attendance/excel")
    public void syStatisticsAttendanceExcel(@RequestBody @Validated SaiYanStatisticsRequest request, HttpServletResponse response) {
        log.info("赛演考勤统计-导出excel，参数：{}", JSONObject.toJSONString(request));
        //获取导出excel表格的数据列表
        List<SaiYanAttendanceStatisticsExcel> resultList = Collections.singletonList(new SaiYanAttendanceStatisticsExcel());
        request.setPageNum(1);
        request.setPageSize(100000);
        List<SaiYanAttendanceStatisticsResponse> list = saiYanStatisticsService.syAttendanceStatistics(request);
        if (CollectionUtil.isNotEmpty(list)) {
            //转导出对象
            resultList = list.stream().map(reportResponse -> {
                SaiYanAttendanceStatisticsExcel excel = new SaiYanAttendanceStatisticsExcel();
                BeanUtils.copyProperties(reportResponse, excel);
                return excel;
            }).collect(Collectors.toList());
        }
        ExportUtil<SaiYanAttendanceStatisticsExcel> exportUtil = new ExportUtil<>();
        exportUtil.export("赛演考勤统计", resultList, response,
                new ExcelMergeUtil(1, new int[]{0,1,2,3,4,5,6,7}, new int[]{0,1,2}));
    }


    @ApiOperation(value = "赛演签到统计-导出excel")
    @PostMapping(value = "/api/sy/statistics/sign/in/excel")
    public void syStatisticsSignInExcel(@RequestBody @Validated SaiYanStatisticsRequest request, HttpServletResponse response) {
        log.info("赛演签到统计-导出excel，参数：{}", JSONObject.toJSONString(request));
        //获取导出excel表格的数据列表
        List<SaiYanSignInStatisticsExcel> resultList = Collections.singletonList(new SaiYanSignInStatisticsExcel());
        request.setPageNum(1);
        request.setPageSize(100000);
        List<SaiYanSignInStatisticsResponse> list = saiYanStatisticsService.sySignInStatistics(request);
        if (CollectionUtil.isNotEmpty(list)) {
            //转导出对象
            resultList = list.stream().map(reportResponse -> {
                SaiYanSignInStatisticsExcel excel = new SaiYanSignInStatisticsExcel();
                BeanUtils.copyProperties(reportResponse, excel);
                return excel;
            }).collect(Collectors.toList());
        }
        ExportUtil<SaiYanSignInStatisticsExcel> exportUtil = new ExportUtil<>();
        exportUtil.export("赛演签到统计", resultList, response,
                new ExcelMergeUtil(1, new int[]{0,1,2,3,4,5,6}, new int[]{0,1,2,3,4,5}));
    }

}
