package com.bcxin.statistics.common.utils;

import com.alibaba.fastjson.JSONObject;
import org.apache.commons.lang3.StringUtils;

import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.*;

public class TuoluojiangUtil {

    /**
     * description：创建用户
     * author：linchunpeng
     * date：2024/12/30
     */
    public static void userCreate(String url, String userId, String cardNo, String name, String mobile) {
        long timeSecond = System.currentTimeMillis()/1000;
        Map<String, String> headerMap = getHeaderMap("user/create".concat("POST") + timeSecond);

        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("uid", userId);
        paramMap.put("name", name);
        paramMap.put("card_id", cardNo);
        paramMap.put("phone", mobile);

        HttpUtil.post(url.concat("/api/ent/internal/user/create"), JSONObject.toJSONString(paramMap), headerMap, false);
    }

    /**
     * description：创建用户
     * author：linchunpeng
     * date：2024/12/30
     */
    public static String getToken(String url, String userId, String cardNo, String orgId) {
        long timeSecond = System.currentTimeMillis()/1000;
        Map<String, String> headerMap = getHeaderMap("user/login".concat("POST") + timeSecond);

        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("uid", userId);
        paramMap.put("ent_id", orgId);
        paramMap.put("card_id", cardNo);

        return HttpUtil.post(url.concat("/api/ent/internal/user/login"), JSONObject.toJSONString(paramMap), headerMap, false);
    }


    /**
     * description：创建企业
     * author：linchunpeng
     * date：2024/12/30
     */
    public static void companyCreate(String url, String orgId, String name, String adminId) {
        long timeSecond = System.currentTimeMillis()/1000;
        Map<String, String> headerMap = getHeaderMap("company/create".concat("POST") + timeSecond);

        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("uniqued", orgId);
        paramMap.put("name", name);
        paramMap.put("uid", adminId);

        HttpUtil.post(url.concat("/api/ent/internal/company/create"), JSONObject.toJSONString(paramMap), headerMap, false);
    }

    /**
     * description：添加员工
     * author：linchunpeng
     * date：2024/12/30
     */
    public static void userJoin(String url, String orgId, String userId, String employeeId) {
        long timeSecond = System.currentTimeMillis()/1000;
        Map<String, String> headerMap = getHeaderMap("user/join".concat("POST") + timeSecond);
        //{"uid":"mbgi2Bra","ent_id":"aSuXCEfz","frames":[{"uniqued":"B6rDQ9E1","frame_id":"OUfUqEKy"}],"uniqued":"MPQFuA6I"}
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("uid", "mbgi2Bra");
        paramMap.put("ent_id", "aSuXCEfz");
        paramMap.put("uniqued", "MPQFuA6I");

        List<Map<String, Object>> frameList = new ArrayList<>();
        Map<String, Object> map = new HashMap<>();
        map.put("frame_id", "OUfUqEKy");
        map.put("uniqued", "B6rDQ9E1");
        frameList.add(map);
        paramMap.put("frames", frameList);

        HttpUtil.post(url.concat("/api/ent/internal/user/join"), JSONObject.toJSONString(paramMap), headerMap, false);
    }

    /**
     * description：获取登录链接的加密参数
     * author：linchunpeng
     * date：2024/12/26
     */
    public static String getLoginEncrypt(String url, String userId, String cardNo, String orgId, String redirect) {
        long timeSecond = System.currentTimeMillis()/1000;
        String encryptString = userId.concat(orgId.toUpperCase(Locale.ROOT)) + timeSecond + "57e13b9b5c841d1a";
        String encryptResult = md5(encryptString);
        if (StringUtils.isNotBlank(url)
                && StringUtils.isNotBlank(userId)
                && StringUtils.isNotBlank(cardNo)
                && StringUtils.isNotBlank(orgId)) {
            return url.concat("/admin/landing?sign=").concat(encryptResult)
                    .concat("&cid=").concat(cardNo)
                    .concat("&uid=").concat(userId)
                    .concat("&eid=").concat(orgId)
                    .concat("&redirect=").concat(redirect);
        }
        return encryptResult;
    }

    /**
     * description：获取调用接口的加密头部参数与值
     * author：linchunpeng
     * date：2024/12/30
     */
    public static Map<String, String> getHeaderMap(String encryptString) {
        String encryptResult = md5(encryptString);
        Map<String, String> headerMap = new HashMap<>();
        headerMap.put("Internal-Sign", encryptResult);
        return headerMap;
    }

    /**
     * description：获取调用接口加密签名
     * author：linchunpeng
     * date：2024/12/30
     */
    public static String md5(String input) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            byte[] messageDigest = md.digest(input.getBytes());
            StringBuilder hexString = new StringBuilder();
            for (byte b : messageDigest) {
                String hex = Integer.toHexString(0xff & b);
                if (hex.length() == 1) {
                    hexString.append('0');
                }
                hexString.append(hex);
            }
            return hexString.toString();
        } catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static void login(String url, String userId, String cardNo, String orgId) {
        long timeSecond = System.currentTimeMillis()/1000;
        Map<String, String> headerMap = getHeaderMap("user/login".concat("POST") + timeSecond);

        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("uid", userId);
        paramMap.put("ent_id", orgId);
        paramMap.put("card_id", cardNo);

        String post = HttpUtil.post(url.concat("/api/ent/internal/user/login"), JSONObject.toJSONString(paramMap), headerMap, false);
        System.out.println(post);
    }

    public static void main(String[] args) {
        //5mWZJaBD	auvrIhc4	690877200010296165	葛鑫	13897247381
        //CT2h6Iht	usWm64xP	44090119800807907X	合锐逸	16611000954
        //EYkgUUXF	WXfjBSN2	440901198007076096	奉陶宁	16611000305
        //Uxp6mIMP	Y26qNnlM	44090119800707033X	倪高远	16611000017

//        userCreate("https://tuoluojiang.test.baibaodun.cn", "111", "111", "葛鑫", "111");
//        userCreate("http://49.4.0.134", "CT2h6Iht", "44090119800807907X", "合锐逸", "16611000954");
//        userCreate("http://49.4.0.134", "EYkgUUXF", "440901198007076096", "奉陶宁", "16611000305");
//        userCreate("http://49.4.0.134", "Uxp6mIMP", "44090119800707033X", "倪高远", "16611000017");

//        companyCreate("https://saas.tuoluojiang.com", "ttttt", "tttttt", "05j2oyi0");

//        userJoin("http://49.4.0.134", "aSuXCEfz", "5mWZJaBD", "auvrIhc4");
//        userJoin("http://49.4.0.134", "aSuXCEfz", "CT2h6Iht", "usWm64xP");
//        userJoin("http://49.4.0.134", "aSuXCEfz", "EYkgUUXF", "WXfjBSN2");
        login("https://saas.tuoluojiang.com", "M49sl6x4", "120101199001011474", "4354nqpL");
//        userJoin("https://saas.tuoluojiang.com", "aSuXCEfz", "Uxp6mIMP", "Y26qNnlM");

//        System.out.println(getToken("https://tljiang.qiye.baibaodun.cn", "600626491767652352--__qFCcCnozYNwzoG3O6Ms", "370921198408165134", "591288896763985921--__AOkTvsah9VLicJhQ1FO"));
        System.out.println(getLoginEncrypt("https://tljiang.qiye.baibaodun.cn", "600626491767652352--__qFCcCnozYNwzoG3O6Ms", "370921198408165134", "591288896763985921--__AOkTvsah9VLicJhQ1FO", "/admin/hr/attendance/setting/team"));

    }
}
