package com.bcxin.platform.common.core.domain;

import com.alibaba.fastjson.JSONArray;
import com.bcxin.platform.common.utils.StringUtils;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * Entity基类
 * 
 * @author task
 */
public class BaseEntity implements Serializable
{
    private static final long serialVersionUID = 1L;

    /** 搜索值 */
    private String searchValue;

    /** 创建者id */
    private String createBy;

    /** 创建者 */
    private String createName;

    /** 创建时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date createTime;

    /** 更新者id */
    private String updateBy;

    /** 更新者 */
    private String updateName;

    /** 更新时间 */
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    private Date updateTime;

    /** 备注 */
    private String remark;


    /** 是否逻辑删除 */
    private String isDelete;

    /**
     * 是否组织管理员
     */
    private boolean domainAdmin;

    /**
     * 管理部门id列表
     */
    private String adminOrgIds;

    /**
     * 管理部门id列表
     */
    private List<String> adminDepartIds;

    /** 请求参数 */
    private Map<String, Object> params;

    public String getSearchValue()
    {
        return searchValue;
    }

    public void setSearchValue(String searchValue)
    {
        this.searchValue = searchValue;
    }

    public String getCreateBy()
    {
        return createBy;
    }

    public void setCreateBy(String createBy)
    {
        this.createBy = createBy;
    }

    public Date getCreateTime()
    {
        return createTime;
    }

    public void setCreateTime(Date createTime)
    {
        this.createTime = createTime;
    }

    public String getUpdateBy()
    {
        return updateBy;
    }

    public void setUpdateBy(String updateBy)
    {
        this.updateBy = updateBy;
    }

    public Date getUpdateTime()
    {
        return updateTime;
    }

    public void setUpdateTime(Date updateTime)
    {
        this.updateTime = updateTime;
    }

    public String getRemark()
    {
        return remark;
    }

    public void setRemark(String remark)
    {
        this.remark = remark;
    }


    public String getIsDelete()
    {
        return isDelete;
    }

    public void setIsDelete(String isDelete)
    {
        this.isDelete = isDelete;
    }

    public Map<String, Object> getParams()
    {
        if (params == null)
        {
            params = new HashMap<>();
        }
        return params;
    }

    public void setParams(Map<String, Object> params)
    {
        this.params = params;
    }

    public String getUpdateName() {
        return updateName;
    }

    public void setUpdateName(String updateName) {
        this.updateName = updateName;
    }

    public String getCreateName() {
        return createName;
    }

    public void setCreateName(String createName) {
        this.createName = createName;
    }

    public boolean isDomainAdmin() {
        return domainAdmin;
    }

    public void setDomainAdmin(boolean domainAdmin) {
        this.domainAdmin = domainAdmin;
    }

    public List<String> getAdminDepartIds() {
        if(StringUtils.isEmpty(adminOrgIds)){
            return null;
        }
        return JSONArray.parseArray(adminOrgIds,String.class);
    }

    public void setAdminDepartIds(List<String> adminDepartIds) {
        this.adminDepartIds = adminDepartIds;
    }

    public String getAdminOrgIds() {
        return adminOrgIds;
    }

    public void setAdminOrgIds(String adminOrgIds) {
        this.adminOrgIds = adminOrgIds;
    }
}
