package com.bcxin.platform.service.attend.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import cn.hutool.core.util.StrUtil;
import com.bcxin.platform.common.constant.Constants;
import com.bcxin.platform.common.exception.BusinessException;
import com.bcxin.platform.common.utils.DateUtils;
import com.bcxin.platform.common.utils.IdWorker;
import com.bcxin.platform.common.utils.bean.BeanUtils;
import com.bcxin.platform.domain.attend.AttendSchedulDetail;
import com.bcxin.platform.mapper.attend.AttendSchedulDetailMapper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import com.bcxin.platform.mapper.attend.AttendChangeShiftMapper;
import com.bcxin.platform.domain.attend.AttendChangeShift;
import com.bcxin.platform.service.attend.AttendChangeShiftService;
import com.bcxin.platform.common.core.text.Convert;
import javax.annotation.Resource;

/**
 * 换班记录Service业务层处理
 * 
 * @author lin
 * @date 2021-09-20
 */
@Service
@Transactional
public class AttendChangeShiftServiceImpl implements AttendChangeShiftService{

    @Autowired
    private AttendChangeShiftMapper attendChangeShiftMapper;

    @Autowired
    private AttendSchedulDetailMapper attendSchedulDetailMapper;

    @Resource
    private IdWorker idWorker;

    /**
     * 查询换班记录
     * 
     * @param id 换班记录ID
     * @return 换班记录
     */
    @Override
    public AttendChangeShift findById(Long id){
        return attendChangeShiftMapper.findById(id);
    }

    /**
     * 查询换班记录列表
     * 
     * @param attendChangeShift 换班记录
     * @return 换班记录
     */
    @Override
    public List<AttendChangeShift> selectList(AttendChangeShift attendChangeShift){
        return attendChangeShiftMapper.selectList(attendChangeShift);
    }

    /**
     * 修改换班记录
     * 
     * @param attendChangeShift 换班记录
     * @return 结果
     */
    @Override
    public int update(AttendChangeShift attendChangeShift){
        if(attendChangeShift.getId() == null){
            attendChangeShift.setCreateTime(DateUtils.getNowDate());
            attendChangeShift.setId(idWorker.nextId());
        }else{
            AttendChangeShift dbAttendChangeShift = attendChangeShiftMapper.findById(attendChangeShift.getId());
            BeanUtils.copyPropertiesIgnore(attendChangeShift,dbAttendChangeShift,true);
            BeanUtils.copyPropertiesIgnore(dbAttendChangeShift,attendChangeShift,false);
        }

        String schedulDetailIds = "";
        List<AttendSchedulDetail> updateScheduls = new ArrayList<>();
        List<AttendSchedulDetail> schedulDetails = attendSchedulDetailMapper.selectListForPer(attendChangeShift.getPerId(),attendChangeShift.getSchedulDate());
        if(schedulDetails.size() == 0){
            throw new BusinessException("申请人当日无排班，无需换班！");
        }
        for (AttendSchedulDetail schedulDetail : schedulDetails) {
            schedulDetail.setPerId(attendChangeShift.getChangePerId());
            schedulDetail.setUpdateBy(attendChangeShift.getUpdateBy());
            schedulDetail.setUpdateTime(DateUtils.getNowDate());
            if(StrUtil.isEmpty(schedulDetailIds)){
                schedulDetailIds = schedulDetail.getId()+"";
            }else{
                schedulDetailIds += "," + schedulDetail.getId();
            }
            updateScheduls.add(schedulDetail);
        }

        String changeSchedulDetailIds = "";
        schedulDetails = attendSchedulDetailMapper.selectListForPer(attendChangeShift.getPerId(),attendChangeShift.getChangeDate());
        List<AttendSchedulDetail> changeSchedulDetails = attendSchedulDetailMapper.selectListForPer(attendChangeShift.getChangePerId(),attendChangeShift.getChangeDate());

        if(schedulDetails.size() > 0 && changeSchedulDetails.size() > 0){
            for (AttendSchedulDetail schedulDetail : schedulDetails) {
                if(Constants.N.equals(schedulDetail.getSchedulType())){
                    continue;
                }
                Date startTime = DateUtils.parseDate(schedulDetail.getStartTime());
                Date endTime = DateUtils.parseDate(schedulDetail.getEndTime());
                for (AttendSchedulDetail changeSchedulDetail : changeSchedulDetails) {
                    if(Constants.N.equals(changeSchedulDetail.getSchedulType())){
                        continue;
                    }

                    Date changeStartTime = DateUtils.parseDate(changeSchedulDetail.getStartTime());
                    Date changeEndTime = DateUtils.parseDate(changeSchedulDetail.getEndTime());
                    if(startTime.getTime()>changeStartTime.getTime() && startTime.getTime() < changeEndTime.getTime()){
                        throw new BusinessException("时间冲突");
                    }
                    if(endTime.getTime()>changeStartTime.getTime() && endTime.getTime()< changeEndTime.getTime()){
                        throw new BusinessException("时间冲突");
                    }
                    if(changeStartTime.getTime()>startTime.getTime() && changeStartTime.getTime() < endTime.getTime()){
                        throw new BusinessException("时间冲突");
                    }
                    if(changeEndTime.getTime()>startTime.getTime() && changeEndTime.getTime()< endTime.getTime()){
                        throw new BusinessException("时间冲突");
                    }
                }
            }
        }

        for (AttendSchedulDetail schedulDetail : changeSchedulDetails) {
            schedulDetail.setPerId(attendChangeShift.getPerId());
            schedulDetail.setUpdateBy(attendChangeShift.getUpdateBy());
            schedulDetail.setUpdateTime(DateUtils.getNowDate());
            if(StrUtil.isEmpty(changeSchedulDetailIds)){
                changeSchedulDetailIds = schedulDetail.getId()+"";
            }else{
                changeSchedulDetailIds += "," + schedulDetail.getId();
            }
            updateScheduls.add(schedulDetail);
        }

        attendSchedulDetailMapper.saveBatch(updateScheduls);
        attendChangeShift.setSchedulDetailIds(schedulDetailIds);
        attendChangeShift.setChangeSchedulDetailIds(changeSchedulDetailIds);
        attendChangeShift.setIsDelete(Constants.N);
        attendChangeShift.setUpdateTime(DateUtils.getNowDate());
        return attendChangeShiftMapper.save(attendChangeShift);
    }

    /**
     * 删除换班记录对象
     * 
     * @param ids 需要删除的数据ID
     * @return 结果
     */
    @Override
    public int deleteByIds(String ids){
        return attendChangeShiftMapper.deleteByIds(Convert.toStrArray(ids));
    }

    /**
     * 删除换班记录信息
     * 
     * @param id 换班记录ID
     * @return 结果
     */
    @Override
    public int deleteById(Long id){
        return attendChangeShiftMapper.deleteById(id);
    }
}
