package com.bcxin.platform.service.attend;

import com.bcxin.platform.domain.attend.AttendSchedulConflict;
import com.bcxin.platform.dto.app.AppAttendSchedulConflictDto;

import java.util.List;

/**
 * 考勤排班冲突Service接口
 * 
 * @author lin
 * @date 2022-02-14
 */
public interface AttendSchedulConflictService{

    /**
     * 查询考勤排班冲突
     * 
     * @param id 考勤排班冲突ID
     * @return 考勤排班冲突
     */
    AttendSchedulConflict findById(Long id);

    /**
     * 查询考勤排班冲突列表
     * 
     * @param attendSchedulConflict 考勤排班冲突
     * @return 考勤排班冲突集合
     */
    List<AttendSchedulConflict> selectList(AttendSchedulConflict attendSchedulConflict);

    /**
     * 根据考勤套id查询考勤排班冲突列表
     *
     * @param attendId 考勤套id
     * @return 考勤排班冲突集合
     */
    List<AppAttendSchedulConflictDto> findByAttendId(Long attendId);

    /**
     * 编辑考勤排班冲突
     * 
     * @param attendSchedulConflict 考勤排班冲突
     * @return 结果
     */
    int update(AttendSchedulConflict attendSchedulConflict);

    /**
     * 批量删除考勤排班冲突
     * 
     * @param ids 需要删除的数据ID
     * @return 结果
     */
    int deleteByIds(String ids);

    /**
     * 删除考勤排班冲突信息
     * 
     * @param id 考勤排班冲突ID
     * @return 结果
     */
    int deleteById(Long id);

    int cover(AttendSchedulConflict attendSchedulConflict);
}
