package com.bcxin.platform.mapper.company;

import com.bcxin.platform.domain.company.PerBaseInfo;
import com.bcxin.platform.dto.PerBaseInfoDto;
import com.bcxin.platform.dto.attend.AttendPerDto;
import com.bcxin.platform.dto.company.PerInfoQueryDto;
import org.apache.ibatis.annotations.Param;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public interface PerBaseInfoMapper{

    /**
     * 查询人员基础信息
     *
     * @param perId 人员基础信息ID
     * @return 人员基础信息
     */
    PerBaseInfo selectPerBaseInfoById(Long perId);

    /**
     * 查询人员基础信息列表
     *
     * @param perBaseInfo 人员基础信息
     * @return 人员基础信息集合
     */
    List<PerBaseInfo> selectPerBaseInfoList(PerBaseInfo perBaseInfo);

    /**
     * 新增人员基础信息
     *
     * @param perBaseInfo 人员基础信息
     * @return 结果
     */
    int insertPerBaseInfo(PerBaseInfo perBaseInfo);

    /**
     * 修改人员基础信息
     *
     * @param perBaseInfo 人员基础信息
     * @return 结果
     */
    int updatePerBaseInfo(PerBaseInfo perBaseInfo);

    /**
     * 删除人员基础信息
     *
     * @param perId 人员基础信息ID
     * @return 结果
     */
    int deletePerBaseInfoById(Long perId);

    /**
     * 批量删除人员基础信息
     *
     * @param perIds 需要删除的数据ID
     * @return 结果
     */
    int deletePerBaseInfoByIds(String[] perIds);

    String getNameById(Long perId);

    List<String> selectNameByPrimaryList(@Param("perIdList") Collection<Long> perIdList);

    /**
     * 通过v5用户id查询
     * @param tlkPerId
     * @return
     */
    PerBaseInfo selectPerBaseInfoByTlkId(String tlkPerId);

    /**
     * 批量保存
     * @param list
     */
    void saveBatch(@Param("list") List<PerBaseInfo> list);

    /**
     * 批量查询
     * @param list
     * @return
     */
    List<PerBaseInfo> findByBatchId(@Param("list") List<PerBaseInfo> list);

    /**
     * 批量查询
     *
     * @param list
     * @return
     */
    List<PerBaseInfo> findByBatchTlkId(@Param("list") List<PerBaseInfoDto> list);

    String getMobilePhoneByUserName(@Param("userName") String userName);

    /**
     * 华为云会议人员信息查询
     *
     * @param dto
     * @return
     * @author llc
     * @date 2019-12-11
     */
    List<LinkedHashMap<String,Object>> pageForhuaweiMeetPerInfo(PerInfoQueryDto dto);


    /**
     * <b> 组装保险负责人所需字段 </b>
     * @param comId 企业id
     * @param createBy 当前操作人id
     * @param list 身份证数组
     * @author ZXF
     * @create 2019/05/20 0020 14:40
     * @version
     * @注意事项 </b>
     */
    List<Map> getByComIdAndCardNo(@Param("comId") Long comId, @Param("createBy") Long createBy, @Param("list") String[] list);

    /**
     * <b> 组装保险负责人所需字段 </b>
     * @param comId 企业id
     * @param createBy 当前操作人id
     * @param perId 负责人id
     * @author ZXF
     * @create 2019/05/20 0020 14:40
     * @version
     * @注意事项 </b>
     */
    List<Map> getByComIdAndPerId(@Param("comId") Long comId, @Param("createBy") Long createBy, @Param("perId") Long perId);

    /**
     * <b> 根据id列查询身份证列 </b>
     * @author ZXF
     * @create 2019/05/22 0022 14:41
     * @version
     * @注意事项 </b>
     */
    String getIdCardNosByPerIds(@Param("list") String[] list);

    List<Map> packageTLInsureData(
            @Param("list") List<Long> list
            ,@Param("comId") String comId
            ,@Param("tlkComId") String tlkComId
            ,@Param("insureStatus") String insureStatus
            ,@Param("applicationId") String applicationId
            ,@Param("formId") String formId);

    List<PerBaseInfo> selectPerBaseInfoByTlkIds(@Param("list")List<String> tlkIds);

    /**
     * <b> 渤海联名卡申请接口需要字段 </b>
     * @author ZXF
     * @create 2020/09/04 0004 13:49
     * @version
     * @注意事项 </b>
     */
    Map<String,String> findPerDecByperIdForBHAPI(@Param("perId") Long perId);

    List<PerBaseInfo> selectPerBaseInfoByPerIds(AttendPerDto searchDto);

    /**
     * 修改当前企业下所有人员身份证x存在小写转大写
     *
     * @param comId 企业id
     * @return 结果
     */
    void updateIdcardNoByComId(@Param("comId") Long comId);
}
