package com.bcxin.platform.mapper.attend;

import com.bcxin.platform.domain.attend.AttendCalendarRest;
import com.bcxin.platform.dto.attend.AttendCalendarRestDetailDto;
import org.apache.ibatis.annotations.Param;

import java.util.List;

/**
 * 考勤打卡日历套-日历Mapper接口
 * 
 * @author lin
 * @date 2021-08-10
 */
public interface AttendCalendarRestMapper {

    /**
     * 查询考勤打卡日历套-日历
     * 
     * @param id 考勤打卡日历套-日历ID
     * @return 考勤打卡日历套-日历
     */
    AttendCalendarRest findById(Long id);

    /**
     * 查询考勤打卡日历套-日历列表
     * 
     * @param attendCalendarDetail 考勤打卡日历套-日历
     * @return 考勤打卡日历套-日历集合
     */
    List<AttendCalendarRestDetailDto> selectList(AttendCalendarRestDetailDto attendCalendarDetail);

    /**
     * 删除考勤打卡日历套-日历
     * 
     * @param id 考勤打卡日历套-日历ID
     * @return 结果
     */
    int deleteById(Long id);

    /**
     * 批量删除考勤打卡日历套-日历
     * 
     * @param ids 需要删除的数据ID
     * @return 结果
     */
    int deleteByIds(String[] ids);

    /****
     * 保存
     * @param attendCalendarDetail
     * @return
     */
    int save(AttendCalendarRest attendCalendarDetail);

    /****
     * 选择修改
     * @param attendCalendarDetail
     * @return
     */
    int updateSelective(AttendCalendarRest attendCalendarDetail);

    /**
     * 批量保存
     * @param list
     */
    void saveBatch(@Param("list") List<AttendCalendarRest> list);

    /**
     * 批量查询
     * @param list
     * @return
     */
    List<AttendCalendarRest> findByBatchId(@Param("list") List<AttendCalendarRest> list);

    int deleteByCalendarIds(String[] calendarIds);
}
