package com.bcxin.platform.domain.wallet;

import com.bcxin.platform.annotation.TableName;
import com.bcxin.platform.common.serializer.LongJsonDeserializer;
import com.bcxin.platform.common.serializer.LongJsonSerializer;
import com.bcxin.platform.util.BaseEntity;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

/**
 * 企业钱包变更事件
 *
 * @author llc
 * @date 2019-09-10
 */
@Data
@TableName("com_wallet_change_event")
public class ComWalletChangeEvent extends BaseEntity<ComWalletChangeEvent> {

    /**
     * 企业钱包变更事件ID
     */
    @ApiModelProperty(value = "企业钱包变更事件ID")
    @JsonSerialize(using = LongJsonSerializer.class)
    @JsonDeserialize(using = LongJsonDeserializer.class)
    private Long comWalletChangeEventId;

    /**
     * 企业钱包变更类型
     */
    @ApiModelProperty(value = "企业钱包变更类型")
    private String comWalletChangeType;

    /**
     * 公司名称
     */
    @ApiModelProperty(value = "公司名称")
    private String comName;

    /**
     * 钱包账户号
     */
    @ApiModelProperty(value = "钱包账户号")
    private String walletAccountNo;

    /**
     * 修改证明信息url
     */
    @ApiModelProperty(value = "修改证明信息url")
    private String changeProveUrl;

    /**
     * 银行卡图片url
     */
    @ApiModelProperty(value = "银行卡图片url")
    private String bankCardUrl;

    /**
     * 审批状态
     */
    @ApiModelProperty(value = "审批状态")
    private String approveStatus;

    /**
     * 审批意见
     */
    @ApiModelProperty(value = "审批意见")
    private String approveContent;

    /**
     * 审批时间
     */
    @ApiModelProperty(value = "审批时间")
    private Date approveTime;

    /**
     * 审批人员ID（内部人员ID）
     */
    @ApiModelProperty(value = "审批人员ID（内部人员ID）")
    @JsonSerialize(using = LongJsonSerializer.class)
    @JsonDeserialize(using = LongJsonDeserializer.class)
    private Long approvePerId;

}