package com.bcxin.platform.domain.company;

import com.bcxin.platform.annotation.DisMultiTenancy;
import com.bcxin.platform.annotation.TableName;
import com.bcxin.platform.common.serializer.LongJsonDeserializer;
import com.bcxin.platform.common.serializer.LongJsonSerializer;
import com.bcxin.platform.util.BaseEntity;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.util.Date;

/**
 * 人员组织关系对象 per_org_relation
 * 
 * @author task
 * @date 2021-04-09
 */
@TableName("per_org_relation")
@DisMultiTenancy
@Data
public class PerOrgRelation extends BaseEntity<PerOrgRelation> {

    private static final long serialVersionUID = 1L;

    /** 人员组织关系ID */
    @JsonSerialize(using = LongJsonSerializer.class)
    @JsonDeserialize(using = LongJsonDeserializer.class)
    @ApiModelProperty(value = "人员组织关系ID")
    private Long perOrgRelationId;

    /** 所在组织类型 */
    @ApiModelProperty(value = "所在组织类型")
    private String orgType;

    /** 所在组织ID */
    @JsonSerialize(using = LongJsonSerializer.class)
    @JsonDeserialize(using = LongJsonDeserializer.class)
    @ApiModelProperty(value = "所在组织ID")
    private Long orgId;

    /** 人员ID */
    @JsonSerialize(using = LongJsonSerializer.class)
    @JsonDeserialize(using = LongJsonDeserializer.class)
    @ApiModelProperty(value = "人员ID")
    private Long perId;

    /** 企业ID */
    @JsonSerialize(using = LongJsonSerializer.class)
    @JsonDeserialize(using = LongJsonDeserializer.class)
    @ApiModelProperty(value = "企业ID")
    private Long comId;

    /**
     * 入职时间
     */
    private Date entryDate;

    /**
     * 离职时间
     */
    private Date leaveDate;

    /**
     * V5关联id
     */
    private String tlkRelationId;

    private String tlkPerId;
}
