package com.bcxin.identify.business.dao;

import com.baomidou.mybatisplus.mapper.BaseMapper;
import com.bcxin.identify.business.domain.LYTrajectory;
import com.bcxin.identify.business.domain.LYTrajectoryTerminal;
import org.apache.ibatis.annotations.Mapper;
import org.apache.ibatis.annotations.Param;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Map;

@Component
@Mapper
public interface LYTrajectoryMapper extends BaseMapper<LYTrajectory> {



    /**
     * <b> 根据省编码查询最后一条的序号 </b>
     * @author ZXF
     * @create 2021/07/22 0022 11:11
     * @version
     * @注意事项 </b>
     */
    Integer getMaxSeqByProvince(@Param("province") String province);

    /**
     * <b> 根据省编码查询可用的key/sid </b>
     * @author ZXF
     * @create 2021/07/22 0022 11:11
     * @version
     * @注意事项 </b>
     */
    Map<String,String> getKeyByProvince(@Param("province") String province);

    /**
     * <b> 根据userid、省编码查询key、sid、tid </b>
     * @author ZXF
     * @create 2021/07/22 0022 11:11
     * @version
     * @注意事项 </b>
     */
    Map<String,String> getTerminalByUserId(@Param("userId") String userId);

    /**
     * <b> 根据userId、tid查询设备是否存在 </b>
     * @author ZXF
     * @create 2021/07/22 0022 11:22
     * @version
     * @注意事项 </b>
     */
    int terminalCount(@Param("userId") String userId,@Param("tId") String tId);

    List<String> groupProvince();

    /**
     * <b> 根据省编码查询剩余可添加设备数量 </b>
     * @author ZXF
     * @create 2021/07/22 0022 11:11
     * @version
     * @注意事项 </b>
     */
    Integer findKeyIsFull(@Param("province") String province);

    /**
     * <b> 每次添加key就创建15条轨迹配置service信息 </b>
     * @author ZXF
     * @create 2021/07/22 0022 11:31
     * @version
     * @注意事项 </b>
     */
    int insertBatchTrajectory(@Param("list") List<LYTrajectory> list);

    /**
     * <b> 新增设备 </b>
     * @author ZXF
     * @create 2021/07/22 0022 14:00
     * @version
     * @注意事项 </b>
     */
    int insertTerminal(LYTrajectoryTerminal terminal);

    /**
     * <b> 根据省编码将service配置表的isFull设置成1（表示省当前的service配置都已满设备） </b>
     * @author ZXF
     * @create 2021/07/22 0022 14:12
     * @version
     * @注意事项 </b>
     */
    int updateFull(@Param("province") String province);
}
