import { routerRedux } from "dva/router";
import { /*  fakeAccountLogin, */ fakeMobileLogin } from "../services/api";

export default {
  namespace: "login",
  state: {
    status: undefined,
    loginAccount:'',//登录的账号
  },
  effects: {
    *accountSubmit({ payload }, { put }) {
      yield put({
        type: "changeSubmitting",
        payload: {
          ...payload,
          value:true
        }
      });
      //const response = yield call(fakeAccountLogin, payload);
      /* yield put({
        type: 'changeLoginStatus',
        payload: response,
      }); */
      yield put({
        type: "changeSubmitting",
        payload: {
          ...payload,
          value:false
        }
      });
    },
    *mobileSubmit({ payload }, { call, put }) {
      yield put({
        type: "changeSubmitting",
        payload: {
          ...payload,
          value:true
        }
      });
      const response = yield call(fakeMobileLogin);
      yield put({
        type: "changeLoginStatus",
        payload: response
      });
      yield put({
        type: "changeSubmitting",
        payload: {
          ...payload,
          value:false
        }
      });
    },
    *logout(_, { put }) {
      yield put({
        type: "changeLoginStatus",
        payload: {
          status: false
        }
      });
      yield put(routerRedux.push("/user/logOn"));
    }
  },

  reducers: {
    changeLoginStatus(state, { payload }) {
      return {
        ...state,
        status: payload.status,
        type: payload.type
      };
    },
    changeSubmitting(state, { payload }) {
      return {
        ...state,
        submitting: payload.value,
        loginAccount:payload.username
      };
    }
  }
};
