//防控指挥的事件数据处理
export default {
  namespace: "command",
  state: {
    //事件列表
    eventList: {
      list: []
    },
    //人员信息
    personList: {
      list: [], //打点的列表数据
      addressList: [], //通讯录存储数据
      selectedId: null, //选中哪一个
    },
    //驻勤信息
    attendanceList: {
      //所有驻勤点页面
      list: [], //打点的列表数据
      typeList: [], //类型查询的驻勤点（保留下来，然后点击此页面的时候，展示已经保存的数据，因为tab页没有重新刷新页面）
      selectedId: null, //选中哪一个
      selectedAttenData: null, //选中的驻勤点要查看人员信息数据
    },
    // 驻勤点保安员信息
    attendancePersonList: {
      list: [], //打点的列表数据
      typeList: [], //类型查询的驻勤点（保留下来，然后点击此页面的时候，展示已经保存的数据，因为tab页没有重新刷新页面）
      selectedId: null, //选中哪一个
      selectedAttenData: null, //选中的驻勤点要查看人员信息数据
    },
    /**
     * 地图上的事件
     */
    clearInfoWindow: false, //是否清除地图上的数据
    tabIndex: {
      //存储当前点击的tab是哪一个，用于驻勤点跳到人员，再从人员跳回到驻勤点的事件
      tabIndex1: "2",
      event: {
        tabIndex2: "1",
      },
      attendance: {
        tabIndex2: "1",
      },
      person: {
        tabIndex2: "1",
      },
    },
    mapStyle: 'satellite',//地图风格，默认是浅色的"normal",深色系是"dark"
    layoutAuthority: {//地图显示图层的权限
      attendanceMapShow: '',
      personMapShow: '',
      aPictureMapShow: '',
      defaultLayer: "",
      basisLayer: "",
      customLayer: "",
      additionalLayer: "",
      policeMapShow: '',
      attendancePermissions: "",
      basisLayerName: "",
      customLayerName: "",
      defaultLayerName: "",
      additionalName: "",
      domainPermissions: "",
      earthLayer: "",
      hardWarePermissions: "",
      peoplePermissions: "",
      commonLogo: "",
      darkLogo: "",
      additionalType: ""
    },
    /**
     * 一张图图层
     */
    //一张图图层的打点数据
    pictureMarkersList: {
      //保安员资源
      securityResource: [],
      //保安公司
      securityCompany: [],
      // 驻勤点
      attendancePoint: [],
      //态势感知的数据
      perception: [],
      //驻勤点的数据
      attendance: [],
      // 驻勤点保安员数据
      attendancePolice: [],
      // 搜索地址数据
      searchAddress: [],
      // 事件打点
      eventMarker: []
    },
    //保安资源有在地图上显示的数据
    securityResourceData: [],
    // 保安公司在地图上显示的数据
    securityCompanyData: [],
    //一张图中的上下左右打开状态
    switchOpenStatus: {
      all: false,
      left: true,
      down: true,
      right: true,
      // is3D: true,
      is3D: false,
      search: false,
      searchViews: true,
      resourceViews: false
    },
    // 图层开关
    mapLayerSwitchState: {
      searchViews: false,
      resourceViews: false,
      eventViews: true
    },
    videoMember: [],//视频人员
    videoType: 0, // 布局类型 0: 九宫格 1: 右侧列表   2: 顶部列表   3: 十六宫格  4: 二十五宫格
    videoGenre: 0, // 功能类型 0: 视频调度(一对多) 1: 视频上拉(一对一)
    recordStatus: 0, // 0：未录制 1：录制中
    // 选中驻勤点信息弹框
    selectAttendInfo:{
      selectAttendId: ""
    },
    // 选中公司信息弹框
    selectComponeyInfo:{
      selectComponeyId: ""
    },
    // 选中的公司列表
    selectComponyList: false,
    /**
     * 警保联动图层数据
     */
    policeData: {
      //分两个tab来存储保安员的打点数据，注意是打点数据
      tab1: {},//以位置来做属性名，属性名下的数值是数组,存储的是打点数据
      tab2: {},
      selectedId: null,//选中点击的元素
      personData: {},//打点在地图上的保安员数据，存储的数据类似以上tab1跟tab2的类型。tab1跟tab2的数据放在一起（因为切换tab会把数据清空，所以不用考虑会重复存储不同tab的保安员数据问题）
    },
    //搜索周边的打点数据（目前用于防控指挥一张图跟警保联动）
    searchAround: {
      securitySearch: [],//保安员
      awarenessSearch: []//动态感知
    },
    searchAroundList: {
      list: [], //打点的列表数据
      addressList: [], //通讯录存储数据
      selectedId: null, //选中哪一个
    },
    earthPoint: null, //地球搜索的点
    gITFPoint: [
      {
        name: "rjyA",
        lng: 118.051053,
        lat: 24.607252,
        gIFTurl: "https://bcxin-vedio-prod.obs.myhuaweicloud.com/glTF/0914san-fbx2/0914san-fbx.gltf",
        isShow: false,
        cityMeshes: null
      },
      {
        name: "rjyB",
        lng: 118.048937,
        lat: 24.611863,
        gIFTurl: "https://bcxin-vedio-prod.obs.myhuaweicloud.com/glTF/B-1/B-1.gltf",
        isShow: false,
        cityMeshes: null
      },
    ],
    object3Dlayer: null,
    // 记录上一步的操作，方便实现返回上一步的功能（目前只适用与 公司\员工\驻勤点 之间的跳转
    backStepInfo: {},
    placeSearch: null, // 搜索组件-输入提示和关键字搜索实体类。只用于清除搜索后的标记
  },
  effects: {
    /*
     * 事件列表
     */
    *fetchEventList({ payload }, { put }) {//更新所有人员信息数据
      yield put({
        type: "changeEventList",
        payload,
      });
    },
    *setEventSelectIndex({ payload }, { put }) {//设置选中事件信息
      yield put({
        type: "changeEventSelectIndex",
        payload,
      });
    },
    /*
     *人员信息
     */
    *fetchPersonList({ payload }, { put }) {//更新所有人员信息数据
      yield put({
        type: "changePersonList",
        payload,
      });
    },
    // 周边搜索-人员信息数据
    *fetchSearchAroundList( { payload }, { put }){
      yield put({
        type: "changeSearchAroundList",
        payload,
      });
    },
    *fetchAttendPoliceList({ payload }, { put }) {//更新驻勤点人员信息数据
      yield put({
        type: "changeAttendPoliceList",
        payload,
      });
    },
    *fetchPersonAddressList({ payload }, { put }) {//更新通讯录页面的人员信息
      yield put({
        type: "changePersonAddressList",
        payload,
      });
    },
    *setPersonSelectIndex({ payload }, { put }) {//设置选中人员信息
      yield put({
        type: "changePersonSelectIndex",
        payload,
      });
    },
    *setSearchMarkSelectIndex({ payload }, { put }) {
      yield put({
        type: "changeSearchMarkSelectIndex",
        payload,
      });
    },
    /*
     *驻勤信息
     */
    *fetchAllAttendanceList({ payload }, { put }) {//更新所有驻勤点打点数据
      yield put({
        type: "changeAllAttendanceList",
        payload,
      });
    },
    //按类型查询的驻勤点
    *fetchAllAttendanceTypeList({ payload }, { put }) {//按类型查询的驻勤点信息
      yield put({
        type: "changeAllAttendanceTypeList",
        payload,
      });
    },
    *setSelectIndex({ payload }, { put }) {//设置选中哪个驻勤点信息
      yield put({
        type: "changeSelectIndex",
        payload,
      });
    },
    *setSelectedAttenData({ payload }, { put }) {//设置要查看哪个驻勤点的具体人员信息
      yield put({
        type: "changeSelectedAttenData",
        payload,
      });
    },
    /*
     *地图上的事件
     */
    *clearInfoWindow({ payload }, { put }) {//清空地图上的信息窗体
      yield put({
        type: "clearInfoWindowData",
        payload,
      });
    },
    *setTabIndex({ payload }, { put }) {//改变tab页面（包括1跟2）
      yield put({
        type: "changeTabIndex",
        payload,
      });
    },
    *setMapStyle({ payload }, { put }) {//设置地图颜色
      yield put({
        type: "changeMapStyle",
        payload,
      });
    },
    *setLayoutAuthority({ payload }, { put }) {//设置地图图层权限
      yield put({
        type: "changeLayoutAuthority",
        payload,
      });
    },
    /**
     * 一张图图层事件
     */
    *setPictureMarks({ payload }, { put }) {
      yield put({
        type: "changePictureMarks",
        payload,
      });
    },
    //设置保安列表资源数据
    *setSecurityResourceData({ payload }, { put }) {
      yield put({
        type: "changeSecurityResourceData",
        payload,
      });
    },
    //设置保安公司数据
    *setSecurityCompanyData({ payload }, { put }) {
      yield put({
        type: "changeSecurityCompanyData",
        payload,
      });
    },
    //设置所有下左右按钮的状态
    *setSwitchOpenStatus({ payload }, { put }) {
      yield put({
        type: "changeSwitchOpenStatus",
        payload,
      });
    },
    *setMapLayerSwitchState({ payload }, { put }) {
      yield put({
        type: "changeMapLayerSwitchState",
        payload,
      });
    },
    *initMapLayerSwitchState({ payload }, { put }){
      yield put({
        type: "initializeMapLayerSwitchState",
        payload,
      });
    },
    *fetchVideoType({ payload }, { put }) {
      yield put({
        type: "changeVideoType",
        payload,
      });
    },
    *fetchVideoGenre({ payload }, { put }) {
      yield put({
        type: "changeVideoGenre",
        payload,
      });
    },
    *fetchRecordStatus({ payload }, { put }) {
      yield put({
        type: "changeRecordStatus",
        payload,
      });
    },
    //视频人员事件
    *fetchVideoMemberList({ payload }, { call, put }) {
      yield put({
        type: "changeVideoMemberList",
        payload,
      });
      /**
       * 如果是增加未进入视频人员，设置60秒的时间
       * 先判断该人是否进来了。如未进入，状态变成‘fail’。若已进入，则不变
       */
      if (!payload.type || payload.type == 'add') {
        const delay = (ms) => new Promise((resolve) => {
          setTimeout(resolve, 60000);//60000
        });
        yield call(delay, 60000);
        yield put({
          type: "changeVideoMemberList",
          payload: {
            ...payload,
            type: 'fail',
          },
        })
      }
      /**
       * 如果用户离开，2秒之后，关掉该用户的状态显示
       */
      if (payload.type == 'leave') {
        const delay = (ms) => new Promise((resolve) => {
          setTimeout(resolve, 2000);//2000
        });
        yield call(delay, 2000);
        yield put({
          type: "changeVideoMemberList",
          payload: {
            ...payload,
            type: 'delete',
          },
        })
      }
    },
    // 选中驻勤点信息
    *setSelectAttendInfo({ payload }, { put }){
      yield put({
        type: "changeSelectAttendInfo",
        payload,
      });
    },
    // 选中公司信息
    *setSelectComponeyInfo({ payload }, { put }){
      yield put({
        type: "changeSelectComponeyInfo",
        payload,
      });
    },
    // 选中保安服务公司
    *setSelectComponyList ({ payload }, { put }){
      yield put({
        type: "changeSelectComponyList",
        payload,
      });
    },
    /**
     * 警保联动图层
     */
    //人员信息以及驻勤信息tab的打点信息存储
    *fetchPoliceData({ payload }, { call, put }) {
      yield put({
        type: "changePoliceData",
        payload,
      });
    },
    //设置人员信息/驻勤信息选中的保安员id
    *setPoliceSelectIndex({ payload }, { put }) {//设置选中事件信息
      yield put({
        type: "changePoliceSelectIndex",
        payload,
      });
    },
    /**
     * 搜索周边功能
    */
    *setSearchViewMark({ payload }, { put }) {//设置搜索周边的打点
      yield put({
        type: "changeSearchViewMark",
        payload,
      });
    },
    *setEarthPoint({ payload }, { put }) {//更新地球搜索的点
      yield put({
        type: "changeEarthPoint",
        payload,
      });
    },
    *setGITFPoint({ payload }, { put }) {//获取gIFT打点列表
      yield put({
        type: "changeGITFPoint",
        payload,
      });
    },
    *setObject3Dlayer({ payload }, { put }) {//获取gIFT打点列表
      yield put({
        type: "changeObject3Dlayer",
        payload,
      });
    },
    *setBackStepInfo({ payload }, { put }) {//设置上一步的操作
      yield put({
        type: "changeBackStepInfo",
        payload,
      });
    },
    *setPlaceSearch({ payload }, { put }) {// 赋值
      yield put({
        type: "changePlaceSearch",
        payload,
      });
    },
  },

  reducers: {
    //事件列表
    changeEventList(state, { payload }) {
      return {
        ...state,
        eventList: {
          ...state.eventList,
          list: payload.list || [],
        },
      };
    },
    changeEventSelectIndex(state, { payload }) {
      //当选中事件的时候，要把人员、驻勤点的清空
      return {
        ...state,
        eventList: {
          ...state.eventList,
          selectedId: payload,
        },
        personList: {
          ...state.personList,
          selectedId: null,
        },
        attendanceList: {
          ...state.attendanceList,
          selectedId: null,
        },
      };
    },
    //人员信息
    changePersonList(state, { payload }) {
      return {
        ...state,
        personList: {
          ...state.personList,
          list: payload.list || [],
        },
      };
    },
    changeSearchAroundList(state, { payload }){
      return {
        ...state,
        searchAroundList: {
          ...state.searchAroundList,
          list: payload.list || [],
        },
      };
    },
    // 驻勤点保安员信息
    changeAttendPoliceList(state, { payload }) {
      return {
        ...state,
        // attendancePersonList: {
        personList: {
          ...state.personList,
          list: payload.list || [],
        },
      };
    },
    changePersonAddressList(state, { payload }) {
      return {
        ...state,
        personList: {
          ...state.personList,
          addressList: payload.addressList || [],
        },
      };
    },
    changePersonSelectIndex(state, { payload }) {
      console.log('changePersonSelectIndex', payload);
      //当选中人员的时候，要把事件、驻勤点的清空
      return {
        ...state,
        eventList: {
          ...state.eventList,
          selectedId: null,
        },
        personList: {
          ...state.personList,
          selectedId: payload,
        },
        attendanceList: {
          ...state.attendanceList,
          selectedId: null,
        },
      };
    },
    //驻勤信息
    changeAllAttendanceList(state, { payload }) {
      return {
        ...state,
        attendanceList: {
          ...state.attendanceList,
          list: payload.attendanceList || [],
        },
      };
    },
    changeAllAttendanceTypeList(state, { payload }) {
      return {
        ...state,
        attendanceList: {
          ...state.attendanceList,
          typeList: payload || [],
        },
      };
    },
    changeSelectIndex(state, { payload }) {
      return {
        ...state,
        eventList: {
          ...state.eventList,
          selectedId: null,
        },
        personList: {
          ...state.personList,
          selectedId: null,
        },
        attendanceList: {
          ...state.attendanceList,
          selectedId: payload,
        },
      };
    },
    changeSelectedAttenData(state, { payload }) {
      return {
        ...state,
        attendanceList: {
          ...state.attendanceList,
          selectedAttenData: payload,
        },
      };
    },
    /*
     *地图上的事件
     */
    //关掉信息窗体，同时让有选中的点，变成没有选中的（包括人员跟驻勤点）
    clearInfoWindowData(state, { payload }) {
      return {
        ...state,
        eventList: {
          ...state.eventList,
          selectedId: null,
        },
        personList: {
          ...state.personList,
          selectedId: null,
        },
        attendanceList: {
          ...state.attendanceList,
          selectedId: null,
        },
        clearInfoWindow: payload,
      };
    },
    changeTabIndex(state, { payload }) {
      return {
        ...state,
        tabIndex: {
          ...state.tabIndex,
          ...payload,
        },
      };
    },
    changeMapStyle(state, { payload }) {
      return {
        ...state,
        mapStyle: payload
      };
    },
    changeLayoutAuthority(state, { payload }) {
      return {
        ...state,
        layoutAuthority: payload
      };
    },
    changePictureMarks(state, { payload }) {
      let markerList = state.pictureMarkersList[payload.type]
      if (payload.options == 'add') {
        markerList.push({
          name: payload.name,
          data: payload.markerData, // marker 对象集
          info: payload.pictureDatas // 每个 marker 对象绑定的数据源
        })
      } else {
        markerList.splice(markerList.findIndex(item => {
          return item.name == payload.name
        }), markerList.length)
      }
      console.log('pictureMarkersList', state.pictureMarkersList);
      console.log('markerList', state.pictureMarkersList);
      return {
        ...state,
        pictureMarkersList: {
          ...state.pictureMarkersList,
          [payload.type]: markerList
        }
      }
    },
    changeSecurityResourceData(state, { payload }) {
      return {
        ...state,
        securityResourceData: payload.dataList
      }
    },
    changeSecurityCompanyData(state, { payload }) {
      return {
        ...state,
        securityCompanyData: payload.dataList
      }
    },
    changeSwitchOpenStatus(state, { payload }) {
      return {
        ...state,
        switchOpenStatus: {
          ...state.switchOpenStatus,
          [payload.type]: payload.value
        }
      }
    },
    changeMapLayerSwitchState(state, { payload }){
      return {
        ...state,
        mapLayerSwitchState: {
          ...state.mapLayerSwitchState,
          [payload.type]: payload.value
        }
      }
    },
    initializeMapLayerSwitchState(state, { payload }){
      return {
        ...state,
        mapLayerSwitchState: {
          searchViews: false,
          resourceViews: false,
          eventViews: false
        }
      }
    },
    changeVideoType(state, { payload }) {
      return {
        ...state,
        videoType: payload
      }
    },
    changeVideoGenre(state, { payload }) {
      return {
        ...state,
        videoGenre: payload
      }
    },
    changeRecordStatus(state, { payload }) {
      return {
        ...state,
        recordStatus: payload
      }
    },
    changeVideoMemberList(state, { payload }) {
      console.log('changeVideoMemberList', payload);
      switch (payload.type) {
        //有人进来视频了，所以更改对应用户的状态
        case 'peerJoin':
          var videoMemberList = JSON.parse(JSON.stringify(state.videoMember))
          var value = videoMemberList.findIndex(item => {
            return item.mobilePhone == payload.memberList.mobilePhone
          })
          videoMemberList[value] = payload.memberList
          return {
            ...state,
            videoMember: videoMemberList
          }
        //增加还没进入视频的人员
        case 'add':
          var videoMemberList = JSON.parse(JSON.stringify(state.videoMember))
          //如果新增加的元素是重复的，使用新元素状态，否则直接添加
          payload.memberList.forEach(x => {
            const value = videoMemberList.findIndex(item => {
              return item.mobilePhone == x.mobilePhone
            })
            if (value == -1) {//不存在，直接添加
              videoMemberList.push(x)
            } else {//已存在，使用新元素状态
              videoMemberList[value].status = x.status
              videoMemberList[value].id = x.id
            }
          })
          return {
            ...state,
            videoMember: videoMemberList
          }
        //人员离开，直接更换对应用户的状态
        case 'leave':
          var videoMemberList = JSON.parse(JSON.stringify(state.videoMember))
          var value = videoMemberList.findIndex(item => {
            return item.mobilePhone == payload.memberList.mobilePhone
          })
          videoMemberList[value] = payload.memberList
          return {
            ...state,
            videoMember: videoMemberList
          }
        //暂时没有失败的状态，所以此状态是根据60秒法则，如果60秒之后，状态还是'no'的，就变成fail
        case 'fail':
          var videoMemberList = JSON.parse(JSON.stringify(state.videoMember))
          for (let i = 0; i < videoMemberList.length; i++) {
            for (let j = 0; j < payload.memberList.length; j++) {
              if (videoMemberList[i].mobilePhone == payload.memberList[j].mobilePhone && videoMemberList[i].status == 'no') {
                videoMemberList[i].status = 'fail'
                videoMemberList[i].id = videoMemberList[i].mobilePhone + 'fail'
              }
            }
          }
          return {
            ...state,
            videoMember: videoMemberList
          }
        //用户离开，更改状态，不显示在列表中
        case 'delete':
          var videoMemberList = JSON.parse(JSON.stringify(state.videoMember))
          var value = videoMemberList.findIndex(item => {
            return item.mobilePhone == payload.memberList.mobilePhone
          })
          videoMemberList[value].status = 'delete'
          videoMemberList[value].id = payload.memberList.mobilePhone + 'delete'
          return {
            ...state,
            videoMember: videoMemberList
          }
        //首次创建视频添加的成员
        default:
          return {
            ...state,
            videoMember: payload.memberList
          }
      }
    },
    changeSelectAttendInfo(state, { payload }){
      return {
        ...state,
        selectAttendInfo:payload,
      }
    },
    changeSelectComponeyInfo(state, { payload }){
      return {
        ...state,
        selectComponeyInfo:payload,
      }
    },
    changeSelectComponyList(state, { payload }){
      return {
        ...state,
        selectComponyList:payload,
      }
    },
    changePoliceData(state, { payload }) {
      switch (payload.options) {
        case 'add':
          return {
            ...state,
            policeData: {
              ...state.policeData,
              [payload.tab]: {
                ...state.policeData[payload.tab],
                [payload.place]: payload.markerData
              },
              personData: {
                ...state.policeData.personData,
                [payload.place]: payload.personData
              }
            }
          }
        case 'reduce':
          return {
            ...state,
            policeData: {
              ...state.policeData,
              [payload.tab]: {
                ...state.policeData[payload.tab],
                [payload.place]: null
              },
              personData: {
                ...state.policeData.personData,
                [payload.place]: null
              }
            }
          }
        case 'clear':
          return {
            ...state,
            policeData: {
              tab1: {},
              tab2: {},
              selectedId: null,
              personData: {}
            }
          }
        default:
          return {
            ...state
          }
      }
    },
    changePoliceSelectIndex(state, { payload }) {
      return {
        ...state,
        policeData: {
          ...state.policeData,
          selectedId: payload
        }
      }
    },
    changeSearchMarkSelectIndex(state, { payload }){
      return {
        ...state,
        searchAroundList: {
          ...state.searchAroundList,
          selectedId: payload,
        },
      };
    },
    changePictureMarks(state, { payload }) {
      let markerList = state.pictureMarkersList[payload.type]
      if (payload.options == 'add') {
        markerList.push({
          name: payload.name,
          data: payload.markerData, // marker 对象集
          info: payload.pictureDatas // 每个 marker 对象绑定的数据源
        })
      } else {
        markerList.splice(markerList.findIndex(item => {
          return item.name == payload.name
        }), markerList.length)
      }
      console.log('pictureMarkersList', state.pictureMarkersList);
      console.log('markerList', state.pictureMarkersList);
      return {
        ...state,
        pictureMarkersList: {
          ...state.pictureMarkersList,
          [payload.type]: markerList
        }
      }
    },
    changeSearchViewMark(state, { payload }) {
      let markerList = state.searchAround[payload.type]
      if (payload.options == 'add') {
        markerList.push({
          name: payload.name,
          data: payload.markerData, // marker 对象集
          info: payload.pictureDatas // 每个 marker 对象绑定的数据源
        })
      } else {
        markerList.splice(markerList.findIndex(item => {
          return item.name == payload.name
        }), markerList.length)
      }

      return {
        ...state,
        searchAround: {
          ...state.searchAround,
          [payload.type]: markerList
        }
      }
      // switch (payload.options) {
      //   case 'add':
      //     switch (payload.type) {
      //       case 'securitySearch':
      //         return {
      //           ...state,
      //           searchAround: {
      //             ...state.searchAround,
      //             securitySearch: payload.markerData
      //           }
      //         }
      //       case 'awarenessSearch':
      //         return {
      //           ...state,
      //           searchAround: {
      //             ...state.searchAround,
      //             awarenessSearch: payload.markerData.concat(state.searchAround.awarenessSearch)
      //           }
      //         }
      //     }
      //     break;
      //   case 'reduce':
      //     switch (payload.type) {
      //       case 'securitySearch':
      //         return {
      //           ...state,
      //           searchAround: {
      //             ...state.searchAround,
      //             securitySearch: []
      //           }
      //         }
      //       case "awarenessSearch":
      //         return {
      //           ...state,
      //           searchAround: {
      //             ...state.searchAround,
      //             awarenessSearch: []
      //           }
      //         }
      //     }
      //     break;
      // }
    },
    //地球搜索的点
    changeEarthPoint(state, { payload }) {
      return {
        ...state,
        earthPoint: payload.earthPoint
      };
    },
    changeGITFPoint(state, { payload }) {
      return {
        ...state,
        gITFPoint: payload
      };
    },
    changeObject3Dlayer(state, { payload }) {
      return {
        ...state,
        object3Dlayer: payload
      };
    },
    //设置上一步的操作
    changeBackStepInfo(state, { payload }) {
      const { backStepInfo } = state;
      if (backStepInfo.isTop) {
        return {
          ...state,
        }
      }
      return {
        ...state,
        backStepInfo: payload
      };
    },
    changePlaceSearch(state, { payload }) {
      return {
        ...state,
        placeSearch: payload
      };
    },
  },
};
