import { request } from "../utils/request";

/**
 * 任务详情-基础信息
 * @author hjj
 */
export function taskBaseInfo(data) {
  return request("/task/detail/list/task-base-info", {
    method: "GET",
    data: data || {}
  });
}


/**
 * 任务列表-创建任务第一个步骤
 * @author hjj
 */

export function taskManagementAddTaskStepOne(data) {
  return request("/task/management/add-task/step-one", {
    method: "POST",
    data: data || {}
  });
}


/**
 * 人员排班
 * 获得任务的班次和排班周期
 */
export function taskComTaskPerShiftListShift(data) {
  return request("/task/com-task-per-shift/list-shift", {
    method: "POST",
    data: data || {}
  });
}

/**
 * 人员排班
 * 获得人员指定月的排班情况
 */
export function taskComTaskPerShiftListPerShift(data) {
  return request("/task/com-task-per-shift/list-per-shift", {
    method: "POST",
    data: data || {}
  });
}

/**
 * 人员排班
 * 校验单个人员排班（支持班次和周期制）
 */
export function taskComTaskPerShiftValidateSinglePerShift(data) {
  return request("/task/com-task-per-shift/validate-single-per-shift", {
    method: "POST",
    data: data || {}
  });
}
/**
 * 人员排班
 * 新增驻勤班次关联
 */
export function taskShiftAddTaskShift(data) {
  return request("/task/shift/add-task-shift", {
    method: "POST",
    data: data || {}
  });
}
/**
 * 人员排班
 * 获取未设置班次列表
 */
export function taskShiftGetNoSetShiftList(data) {
  return request("/task/shift/get-no-set-shift-list", {
    method: "GET",
    data: data || {}
  });
}

/**
 * 人员排班
 * 设置人员排班（支持班次，周期制）
 */
export function taskComTaskPerShiftSetSinglePerShift(data) {
  return request("/task/com-task-per-shift/set-single-per-shift", {
    method: "POST",
    data: data || {}
  });
}


/**
 * 人员排班
 * 重置单个人员当月的排班
 */
export function taskComTaskPerShiftResetSinglePerShift(data) {
  return request("/task/com-task-per-shift/reset-single-per-shift", {
    method: "POST",
    data: data || {}
  });
}

/**
 * 人员排班
 * 获得人员指定月的排班情况（分页，查看模式）
 */
export function taskComTaskPerShiftPagePerShift(data) {
  return request("/task/com-task-per-shift/page-per-shift", {
    method: "POST",
    data: data || {}
  });
}


/**
 * 任务考勤日统计分页查询
 * @author Wfh
 */
export function getdayStatisticsDataTask(data) {
  return request('/task/count/task-count/page-for-count-per-task-date', {
    method: 'GET',
    data: data || {}
  });
}
/**
 * 任务考勤月统计分页查询
 * @author Wfh
 */
export function getmonthStatisticsDataTask(data) {
  return request('/task/count/task-count/page-for-count-per-task-month', {
    method: 'GET',
    data: data || {}
  });
}
/**
 * 获取部门--获取考勤统计数据详情
 * @author Wfh
 */
export function getAttendRecordDetailTask(data) {
  return request('/task/count/task-count/get-task-record-list', {
    method: 'GET',
    data: data || {}
  });
}
/**
 * 获取部门--修改考勤统计数据详情
 * @author Wfh
 */
export function changeRecordDetailTask(data) {
  return request('/task/count/task-count/update-task-record', {
    method: 'POST',
    data: data || {}
  });
}



