/**
 * 匿名加入会议
 */
import React, { Component } from "react";
import { connect } from "dva";
import { Form, Input, Button, Spin } from "antd";
import "../meeting.less";
import {
  minFormItemLayout,
  minSubmitFormLayout,
} from "../../../constants/formItemLayout";
@connect((state) => ({
  client: state.client.client,
  comName: state.global.companyInfo.comName,
  username: state.user.currentUser.name,
  joinMeetingStatus: state.client.joinMeetingStatus,
}))
@Form.create()
export default class AnonymityJoin extends Component {
  constructor(props, context) {
    super(props, context);
    this.state = {
      joinMeetingStatus: this.props.joinMeetingStatus,
    };
  }
  componentDidMount() {}
  componentWillReceiveProps(nextProps) {
    if (nextProps.joinMeetingStatus !== this.state.joinMeetingStatus) {
      this.setState({
        joinMeetingStatus: nextProps.joinMeetingStatus,
      });
    }
  }
  handleSubmit() {
    this.props.form.validateFields((err, values) => {
      if (!err) {
        this.props.dispatch({
          type: `client/setJoinMeetingStatus`,
          payload: {
            joinMeetingStatus: true,
          },
        });
        var anonymousConfParam = {
          confId: values.conferenceId.trim(),
          confPasswd:
            values.confPasswd === undefined
              ? values.confPasswd
              : values.confPasswd.trim(),
          displayName: values.nickname,
          // callType: 1
        };
        var serverInfo = {
          serverAddress: "bmeeting.huaweicloud.com",
          serverPort: 443,
        };
        // window.setHweiMeeingNickname = values.nickname;
        this.props.client.joinAnonymousConf(
          anonymousConfParam,
          serverInfo,
          function callback(ret) {
            // alert("joinAnonymousConf call back" + JSON.stringify(ret));
            console.log(ret);
          }
        );
      }
    });
  }
  render() {
    const { getFieldDecorator } = this.props.form;
    return (
      <div className="meeting">
        <Spin tip="正在加入会议..." spinning={this.state.joinMeetingStatus}>
          <Form>
            <Form.Item {...minFormItemLayout} label="会议ID">
              {getFieldDecorator("conferenceId", {
                rules: [{ required: true, message: "请输入会议ID" }],
              })(<Input placeholder="请输入会议ID" />)}
            </Form.Item>
            <Form.Item {...minFormItemLayout} label="会议密码">
              {getFieldDecorator(
                "confPasswd",
                {}
              )(<Input placeholder="请输入会议密码" />)}
            </Form.Item>
            <Form.Item
              {...minFormItemLayout}
              label="用户昵称"
              extra={
                <span className="placeholder">提示：请输入姓名+公司名称</span>
              }
            >
              {getFieldDecorator("nickname", {
                initialValue: this.props.username + "+" + this.props.comName,
              })(<Input placeholder="请输入姓名+公司名称" maxLength={127}/>)}
            </Form.Item>
            <Form.Item {...minSubmitFormLayout}>
              <Button
                type="primary"
                htmlType="submit"
                onClick={() => this.handleSubmit()}
              >
                加入会议
              </Button>
            </Form.Item>
          </Form>
        </Spin>
      </div>
    );
  }
}
