/**
 * 修改云会议室
 */
import React, { Component } from "react";
import { connect } from "dva";
import {
  Form,
  Input,
  Button,
  DatePicker,
  Radio,
  Tabs,
  Modal,
  Switch,
  Popover,
  Select,
  message
} from "antd";
import {
  updateHuaweiCloudMemberVmr,
  getHuaweiCloudMemberVmrList
} from "../../../services/api";
const formItemLayout = {
  labelCol: {
    xs: { span: 12 },
    sm: { span: 8 }
  },
  wrapperCol: {
    xs: { span: 12 },
    sm: { span: 10 }
  }
};
const { confirm } = Modal;
@connect(state => ({}))
@Form.create()
export default class Modify extends Component {
  constructor(props, context) {
    super(props, context);
    this.state = {
      modifyStatus: props.modifyStatus,
      selectValue: props.value,
      memberVmrPageParm: {
        pageSize: 1,
        pageNumber: 1,
        searchKey: null,
        specialVmr: ""
      },
      memberVmrList: [],
      currentVmrValue: {
        vmrName: "",
        chairPwd: "",
        allowGustFirst: ""
        // gustFirstNotice: ''
      } //当前匹配的云会议室信息
    };
  }
  componentDidMount() {
    //获取用户详情
    this._getHuaweiCloudMemberVmrList();
  }
  componentWillReceiveProps(nextProps) {
    // this.setState({
    //   modifyStatus: nextProps.modifyStatus,
    //   value: nextProps.value
    // });
  }
  //获取个人用户的云会议室
  _getHuaweiCloudMemberVmrList() {
    getHuaweiCloudMemberVmrList(this.state.memberVmrPageParm)
      .then(res => {
        if (res.retType === "0") {
          const memberList = JSON.parse(
            JSON.stringify(this.state.memberVmrList)
          );
          // memberList.concat(res.data.data)
          this.setState({
            memberVmrList: memberList.concat(res.data.data)
          });
          if (
            res.data.count >
            this.state.memberVmrPageParm.pageSize *
              this.state.memberVmrPageParm.pageNumber
          ) {
            this.setState(
              {
                memberVmrPageParm: {
                  ...this.state.memberVmrPageParm,
                  pageNumber: this.state.memberVmrPageParm.pageNumber + 1
                }
              },
              () => {
                this._getHuaweiCloudMemberVmrList();
              }
            );
          } else {
            this.state.memberVmrList.forEach(item => {
              if (item.vmrId === this.state.selectValue.vmrId) {
                this.setState({
                  currentVmrValue: item
                });
              }
            });
          }
          // console.log(memberList)
        }
      })
      .catch(err => {
        //如果接口报错，就把修改页面关掉
        if (err.retType !== "0") {
          this.props.modifyCancel();
        }
      });
  }
  _handleSubmit() {
    this.props.form.validateFields((err, values) => {
      if (!err) {
        const _this = this;
        confirm({
          title:
            "会议信息被修改后，已经发布的会议将会受到影响。请在修改后，将原会议删除，重新创建会议并告知与会人员。",
          cancelText: "取消",
          okText: "修改",
          onOk() {
            updateHuaweiCloudMemberVmr({
              id: _this.state.currentVmrValue.id,
              ...values,
              allowGustFirstStr: values.allowGustFirst ? "1" : "0"
              // gustFirstNoticeStr: values.gustFirstNotice ? '1' : '0'
            }).then(res => {
              if (res.retType === "0") {
                _this.props.modifyOK();
              }
            });
          },
          onCancel() {
            // _this.props.modifyCancel()
          }
        });
      }
    });
  }
  render() {
    const { getFieldDecorator } = this.props.form;
    const { modifyStatus, currentVmrValue } = this.state;
    return (
      <div>
        <Modal
          title="修改云会议室信息"
          visible={modifyStatus}
          onOk={() => this._handleSubmit()}
          onCancel={() => this.props.modifyCancel()}
        >
          <Form>
            <Form.Item {...formItemLayout} label="云会议室名称">
              {getFieldDecorator("vmrName", {
                initialValue: currentVmrValue.vmrName,
                rules: [{ required: true, message: "请选择会议类型" }]
              })(
                <Input
                  placeholder="请输入云会议室名称"
                  maxLength={128}
                  minLength={1}
                />
              )}
            </Form.Item>
            <Form.Item {...formItemLayout} label="来宾密码">
              {getFieldDecorator("gustPwd", {
                initialValue: currentVmrValue.gustPwd,
                rules: [{ required: true, message: "请输入来宾密码" }]
              })(
                <Input
                  placeholder="请输入来宾密码"
                  maxLength={16}
                  minLength={4}
                />
              )}
            </Form.Item>
            <Form.Item {...formItemLayout} label="主席密码">
              {getFieldDecorator("chairPwd", {
                initialValue: currentVmrValue.chairPwd,
                rules: [{ required: true, message: "请输入主席密码" }]
              })(
                <Input
                  placeholder="请输入主席密码"
                  maxLength={16}
                  minLength={4}
                />
              )}
            </Form.Item>
            <Form.Item {...formItemLayout} label="是否允许来宾先入会">
              {getFieldDecorator("allowGustFirst", {
                initialValue: currentVmrValue.allowGustFirst,
                // initialValue: "true",
                rules: [{ required: true, message: "请输入主席密码" }]
              })(
                <Radio.Group>
                  <Radio value={true}>是</Radio>
                  <Radio value={false}>否</Radio>
                </Radio.Group>
              )}
            </Form.Item>
            {/* <Form.Item
              {...formItemLayout}
              label="是否通知会议室所有者"
            >
              {getFieldDecorator("gustFirstNotice", {
                initialValue: currentVmrValue.gustFirstNotice,
                rules: [{ required: true, message: "请输入主席密码" }]
              })(
                <Radio.Group
                >
                  <Radio value={true}>是</Radio>
                  <Radio value={false}>否</Radio>
                </Radio.Group>
              )}
            </Form.Item> */}
          </Form>
        </Modal>
      </div>
    );
  }
}
