
import { Modal } from 'antd';
import { saveInsBlbMinusPreservationService, minusBatchRelevancePer } from '../../../../../services/api';
export default function () {
  return [
    {
      title: '序号',
      dataIndex: 'number',
      key: 'number'
    },
    {
      title: '姓名',
      dataIndex: 'name',
      key: 'name'
    },
    {
      title: '手机号',
      dataIndex: 'mobilePhone',
      key: 'mobilePhone'
    },
    {
      title: '身份证号',
      dataIndex: 'idCardNo',
      key: 'idCardNo'
    },
    {
      title: '人员类别',
      dataIndex: 'majorGroup',
      key: 'majorGroup'
    },
    {
      title: '关联保单号',
      dataIndex: 'policyNo',
      key: 'policyNo'
    },
    {
      title: '保单有效期',
      dataIndex: 'effectDate',
      key: 'effectDate'
    },
    {
      title: '购买方式',
      dataIndex: 'buyModeName',
      key: 'buyModeName'
    },
    {
      title: '在职状态',
      dataIndex: 'incumbencyName',
      key: 'incumbencyName',
      render: (text, record) => (
        record.incumbencyName == '在职' ? <span style={{ color: '#00cc66' }}>在职</span> : <span style={{ color: '#ff6600' }}>离职</span>
      )
    },

    {
      title: '操作',
      key: 'operation',
      render: (text, record) => (
        <div>
          <span
            style={{
              color: '#108EE9',
              cursor: 'pointer',
              marginRight: '20px'
            }}
            onClick={() => {
              Modal.confirm({
                title: '是否为选中的人员进行减员操作？',
                content: (<div>
                  <p>关联线下保单，则直接移除关联；</p>
                  <p>关联线上保单，则提交减员申请。</p>
                </div>),
                okText: '确认',
                onOk: () => {
                  // 线上保单
                  if (record.buyMode == '1') {
                    const perIds = record.perId;
                    const orderId = record.orderId;
                    saveInsBlbMinusPreservationService({ orderId, perIds }).then(res => {
                      Modal.success({
                        title: '提交减员申请成功！',
                        okText: '确定',
                        content: <p className="modal_tip left0">注：关联线上保单时，需要等待保险公司审核，请在<a>批单申请记录中</a>查看进度。</p>
                      });
                      // 重置选中项
                      this.setState({
                        selectedRows: [], //表格中选中的数组
                        selectedRowKeys: [],
                      });
                      this.props.updateTable();
                    });
                  } else {  //线下
                    const idCards = record.idCardNo;
                    const comInsId = record.comInsId;
                    minusBatchRelevancePer({ idCards, comInsId }).then(res => {
                      // Modal.success({
                      //   title: '移除成功！',
                      //   content: <p className="modal_tip left0">已将所选选择人员移除保障状态！</p>
                      // });
                      Modal.confirm({
                        title: '上传批单提示',
                        content: (<div>
                          <p style={{ color: 'red' }}>*企业若发生人员变动，可通过【保险保单管理】-【修改】上传批单，后台将进行人工校验，请务必上传真实有效数据！</p>
                          <p>本次共移除<span style={{ color: 'red' }}>1</span>位，请及时上传相应批单！</p>
                        </div>),
                        okText: '马上办理',
                        cancelText: '取消',
                        onOk: () => {
                          this.props.history.push(`/insurancemanagement/enterpriseinsurance/insurancedetails?comInsId=${comInsId}&edit=00`);
                        }
                      });
                      // 重置选中项
                      this.setState({
                        selectedRows: [], //表格中选中的数组
                        selectedRowKeys: [],
                      });
                      this.props.updateTable();
                    });
                  }
                },
                cancelText: '取消'
              });
            }}
          >
            减员
          </span>
        </div>
      )
    }
  ];
}