
import $modal from '../../../../../../utils/modal';
import { saveInsBlbMinusPreservationService, minusBatchRelevancePer } from '../../../../../../services/api';
export default function () {
  return [
    {
      title: '序号',
      dataIndex: 'number',
      key: 'number'
    },
    {
      title: '保单号',
      dataIndex: 'policyNo',
      key: 'policyNo'
    },
    {
      title: '产品名称',
      dataIndex: 'productName',
      key: 'productName',
      render: (text) => (
        <div style={{ maxWidth: 200 }}>
          {text}
        </div>
      )
    },
    {
      title: '购买方式',
      dataIndex: 'buyFS',
      key: 'buyFS'
    },
    {
      title: '减员人数',
      dataIndex: 'num',
      key: 'num'
    },
    {
      title: '操作',
      key: 'operation',
      render: (text, record, index) => (
        <a onClick={() => {
          console.log(index);
          const { buyMode, perIds, idCards, blbOrderId, comInsId, num, removed } = record;
          // 已经删除了
          if (removed === true) return;

          const setImportInfo = () => {
            const { importInfo } = this.props;
            importInfo.delCount = importInfo.delCount || 0;
            importInfo.delCount = importInfo.delCount + num;
            // 将当前行设置成已经删除状态
            // record.removed = true;
            importInfo.minusInsList.splice(index, 1);
            this.props.setState({
              importInfo
            }, () => {
              $modal(
                '提交减员成功！',
                <span style={{ color: '#F59A23' }}>
                  注：本次导入人数共
                <em style={{ color: '#108EE9' }}>{importInfo.successCount}</em>
                人，已操作减员
                <em style={{ color: '#108EE9' }}>{importInfo.delCount}</em>
                人，剩余
                <em style={{ color: '#108EE9' }}>{importInfo.successCount - importInfo.delCount}</em>
                人待提交减员
              </span>,
                [
                  {
                    text: '继续',
                    type: 'primary'
                  }
                ],
                'success'
              );
            });
          }
          // 线上保单
          if (buyMode == 1) {
            saveInsBlbMinusPreservationService({ orderId: blbOrderId, perIds }).then(res => {
              this.props.updateTable();
              setImportInfo();
            });
          } else {//线下
            minusBatchRelevancePer({ idCards, comInsId }).then(res => {
              this.props.updateTable();
              setImportInfo();
            });
          }
        }}>
          提交减员
        </a>
      )
    }
  ];
}