import React from 'react';
import { connect } from 'dva';
import HeaderComponent from './HeaderComponent';
import { Icon, Button,message } from 'antd';
import {getAccountConfirmApi,getComWalletServiceOpenInfo,getComWalletAccount} from '../../../services/api';
@connect(state => ({
  global: state.global
}))
export default class BusinessWallet extends React.Component {
  constructor(props, context) {
    super(props, context);
    this.state = {
     companyInfo: JSON.parse(window.sessionStorage.getItem('companyInfo'))||this.props.global.companyInfo,  // 公司信息
    };
  }
  //修改资料--返回第二步，修改开户资料
  BackupdateAccontInfo=()=>{
    this.props.setStatus(2)
  }
  //去认证
  onlineCert=()=>{
    // debugger
    console.log(this.state)
    const obj={comId:this.state.companyInfo.comId};//去认证传递的参数
    getAccountConfirmApi(obj).then(res=>{
       console.log('res',res)
       if(res.data&&res.data.redirectParam){
        window.open(res.data.redirectParam)
       }
    })
  }
  GoCompanyList=async ()=>{
    await getComWalletAccount().then(res => {})//先去获取企业钱包账户资料-宏任务同步
    getComWalletServiceOpenInfo().then(async res=>{
      const { isAuthorize, isCompleteOpen } = res.data;  
      if(isAuthorize==1&&isCompleteOpen==1){//已完成认证
         this.props.setStatus(5)
      }else{
         message.warning('未认证，点击"去认证"')
      }
    })
  }
  render() {
    return (
       <div>
         <HeaderComponent breadcrumb={['企业钱包', '开通钱包']} step={2}></HeaderComponent>
         <div className="success_container">
           <Icon type="check-circle" theme="twoTone" twoToneColor="#52c41a" className="success_icon" />
           <div className="success_info">提交成功，请进行在线认证</div>
           <div className='infoTips'>温馨提示：未认证点击‘去认证’，已完成认证点击‘进入企业账户’</div>
           <div className='stepButton'>
           <Button 
            type="primary"
            onClick={() => {
             this.BackupdateAccontInfo();
            }}
           >
             修改资料
            </Button>
           <Button 
            type="primary"
            onClick={() => {
             this.onlineCert();
            }}
           >
             去认证
            </Button>
           <Button 
            type="primary"
            onClick={() => {
              this.GoCompanyList();
            }}
           >
             进入企业账户
            </Button>
            </div>
         </div>
       </div>
    );
  }
}
