import React, { Component } from "react";
import {
  Alert, Button, Modal, DatePicker
} from 'antd';
import moment from 'moment';
// import SearchForm from './SearchForm';
import columnsFun from './column';
import PTable from '../../../../../components/Pro/PTable';
import { createVoucherEvent } from '../../../../../services/api';
const { RangePicker } = DatePicker;
export default class StepFive extends Component {
  constructor(props, context) {
    super(props, context);
    this.state = {
      forceUpdate: false,
      pageParm: { //任务列表请求参数
        pageSize: '10',
        pageNumber: '1'
      },
      paramsInit: false, //参数是否准备好

      createVisible: false,
      dates: [],
      requestDate: moment()  //请求接口的时间用于控制时间控件
    };
  }

  componentDidMount() {

  }
  componentDidUpdate() {

  }
  static getDerivedStateFromProps(nextProps, prevState) {

  }
  _search = (values) => {
    this.setState({
      pageParm: {
        ...this.state.pageParm,
        ...values
      },
      paramsInit: true
    });
  }
  _updateTable = () => {
    this.setState({
      forceUpdate: true
    }, () => {
      this.setState({
        forceUpdate: false
      });
    });
  }
  _createTask = () => {
    this.setState({
      createVisible: true
    });
  }
  _createCancel = () => {
    this.setState({createVisible: false});
  }
  render() {
    const columns = columnsFun.call(this);
    return (
      <div className="wallet_container">
        <Alert message={
          <span>电子回单下载：请先新建下载任务，系统会自动将需要下载的电子回单打包成压缩包并提供下载链接进行下载。
            <br/>
            若需下载的电子回单文件较多时，处理时间较长，您可稍后访问页面进行下载。
          </span>
        } type="warning" showIcon />
        {/* <SearchForm
          style={{ marginLeft: 10 }}
          onSearch={this._search}
        /> */}
        <Button type="primary" style={{ marginTop: 15 }} onClick={this._createTask}>新增下载任务</Button>
        <PTable
          style={{ marginTop: 20 }}
          columns={columns}
          url="voucherPageVoucherEvent"
          pageParm={this.state.pageParm}
          forceUpdate={this.state.forceUpdate}
          pagination={{ showTotal: total => `总共 ${total} 条` }}
          dateChange={data => {
            this.setState({
              requestDate: data.date
            });
          }}
        />


        <Modal
          title="新建下载任务"
          visible={this.state.createVisible}
          destroyOnClose={true}
          maskClosable={false}
          onOk={() => {
            const { dates } = this.state;
            if(dates.length <= 0) {
              return Modal.warning({
                title: '请选择时间',
                content: '您还未选择时间',
                okText: '确定',
                okType: 'primary'
              });
            }
            const [ startDate, endDate ] = dates;
            createVoucherEvent({startDate, endDate}).then((res) => {
              this._updateTable();
              this._createCancel();
              Modal.success({
                title: '下载任务新建成功',
                content: '下载文件较多时，耗时较长，请耐心等待',
                okText: '确定',
                okType: 'primary'
              });
            });
          }}
          onCancel={this._createCancel}
        >
          <RangePicker 
            disabledDate={(current) => {
              return current > moment(this.state.requestDate).endOf('day');
            }}
            onChange={(date, dateString) => {
            this.setState({
              dates: dateString
            });
          }} />
          <p style={{color: 'orange', marginTop: 10}}>
            注：系统将根据您选择的交易时间，查询相应的手指明细并自动批量下载电子回单文件。
          </p>
        </Modal>
      </div>
    );
  }
}
