import React, { Component } from 'react';
import { Modal, Icon } from 'antd';
// import { getConfigUpdateMsgInfo } from '../../../services/api';
import { connect } from 'dva';
import './less/Welcome.less';
import { domainConfig } from '../../../utils/config';
import $nModal from '../../../utils/modal/nModal';
const welcomeImg = require('../../../assets/images/welcome.jpg');

@connect(state => ({
  companyInfo: state.global.companyInfo,
  isShowSystemNotice: state.global.isShowSystemNotice
}))
export default class Welcome extends Component {
  constructor(props, context) {
    super(props, context);
    this.state = {
      prompt: false, //这个状态后端给
      approvalState: '', //1表示data.approvalstate != "002" 并且 data.approvalstate != "003" 并且 data.approvalstate != "005",否则是'0'
      modalVisible: true,
      msgData: null
    };
  }
  handleOk = (e) => {
    this.setState({
      modalVisible: false
    });
    $nModal({
      title: "平台通知",
      footer: null,
      width: 800,
      // content: (
      //   <NotifList/>
      // )
    });
    this.props.dispatch({
      type: 'global/changeShowSystemNotice',
      payload: true,
    });
  }
  handleCancel = (e) => {
    this.setState({
      modalVisible: false
    });
    this.props.dispatch({
      type: 'global/changeShowSystemNotice',
      payload: true,
    });
  }
  componentWillMount() {
    // console.log('iverry');
    // const nowDate = new Date().getTime();
    // const endDate = new Date('2019-03-20').getTime();
    // if(endDate <= nowDate) {
    //   this.setState({
    //     modalVisible: false
    //   });
    // }
    // getConfigUpdateMsgInfo({}).then(res => {
    //   if (res.data) {
    //     this.setState({
    //       msgData: res.data,
    //       modalVisible: true
    //     });
    //   }
    // });
  }
  componentDidMount() {
  }
  cancelPromptModal = () => {
    this.setState({
      prompt: false
    });
  };

  render() {
    return (
      <div className="Welcome">
        {/* <div
                    style={{
                        background: `url("${require('../../../assets/images/welcome.jpg')}") no-repeat`,
                    }} /> */}
        <div
        // className="welcome-bg"
        >

          {/* iverry */}
          {this.state.msgData && !this.props.isShowSystemNotice && (<div>
            <Modal
              title={this.state.msgData.title}
              visible={this.state.modalVisible}
              okText='查看历史通知'
              cancelText="知道了"
              onOk={this.handleOk}
              okButtonProps={{ type:'default' }}
              onCancel={this.handleCancel}
              cancelButtonProps={{ type:'primary' }}
              className="update_modal"
            >
                <div dangerouslySetInnerHTML={{ __html: this.state.msgData.content }}>
                {/* <p>尊敬的用户：<br/>
                      您好！为向保安企业提供更全面、更高效的企业管理服务，现为您免费更新全新版百保盾系统，新版百保盾系统在界面及功能上进行了优化升级及优化，请详细查看以下注意事项并开启使用。</p>
                  <p><br/>
                      <span>注意事项：</span><br/>
                      1、新系统中，新增了考勤、手机快捷排班、审批、自动算薪等功能，若有不理解的，请点击右上角的【帮助】按钮，查看帮助文档；<br/>
                      2、旧系统迁移时，新旧系统信息录入存在差异，若有个别信息缺失的，请相应在新系统中补充；<br/>
                      <span>3、新系统需要重新安装新版的 百保盾PRO APP进行使用，原旧版APP后期将逐步暂停服务，请及时通知员工更换安装；</span><br/>
                      4、系统中，如有使用不便或问题的，可通过界面右侧的【在线咨询】服务进行咨询。</p>
                  <p><span>百保盾Pro 下载地址：http://www.baibaodun.cn/download_2.0.html<br/>
                      </span>
                  </p> */}
              </div>

            </Modal>
          </div>)
          }

          {/* iverry end domainConfig */}
          <img src={welcomeImg} alt={`欢迎登录${domainConfig.getName(this.props.companyInfo.regProvince,this.props.companyInfo.regCity)}`} />
        </div>
        <div className="welcome-text">{`欢迎登录${domainConfig.getName(this.props.companyInfo.regProvince,this.props.companyInfo.regCity)}`}</div>
        <Modal
          width={800}
          title="提示"
          visible={this.state.prompt}
          onCancel={() => {
            this.cancelPromptModal();
          }}
          onOk={() => {
            this.cancelPromptModal();
            console.log(this.props);
            this.props.ok();
          }}
          okText="马上去填写"
          cancelText="再看看"
        >
          <div>
            <p style={{ textAlign: 'center' }}>
              <Icon
                type="exclamation-circle"
                style={{
                  color: 'white',
                  background: '#f1ce1b',
                  fontSize: '80px',
                  borderRadius: '50%',
                  display: 'inline-block'
                }}
              />
            </p>
            {this.state.approvalState === '0' ? (
              <p>
                <span style={{ textIndent: '2em', display: 'inline-block' }}>
                  根据陕西省公安厅《关于实行保安从业单位年度报告制度和换发保安服务（培训）许可证的通知》以及《关于启用陕西省新版保安服务监管信息系统有关工作的通知》要求，2018年度保安从业单位在线进行年度报告备案工作已经开始。
                </span>
                <br />
                <span style={{ textIndent: '2em', display: 'inline-block' }}>
                  为使年度报告更加准确全面地反映保安从业单位经营情况，按上级指示，现须进行相关历史信息采集补录工作，系统将在11月1日开放年报自动生成和在线提交功能，以便保安服务（培训）单位在规定时间内完成年度报告备案工作，请务必于2018年12月31日前完成该项工作。
                </span>
              </p>
            ) : (
                <p>
                  <span style={{ textIndent: '2em', display: 'inline-block' }}>
                    根据陕西省公安厅《关于实行保安从业单位年度报告制度和换发保安服务（培训）许可证>的通知》以及《关于启用陕西省新版保
                    安服务监管信息系统有关工作的通知》要求，2018年度保安从业单位在线进行年度报告备案工作已经开始。请于2018年12月31号之前生成年度报告，并提交给公安机关进行审批！
                </span>
                </p>
              )}
          </div>
        </Modal>
      </div>
    );
  }
}
