/**
 * 定义驻勤点信息信息窗体 - 高级版(不可与基础版弹框混用)
 * @param type:用于一张图
 */
import RreactDom from 'react-dom';
import { APictureAddPictueMarks } from "../../GIS/APicture/func"
import { getDomainInfo } from '@services/api';
import eventCenter from "@common/events"; // 引入 EventEmitter
import { recordAdd, recordHistory, recordBack, recordRemove, recordTo } from '@common/recordHistory';
import { showCompanyPointInfo } from '@gis/biz';

export default function (data, type = '', marker) {
  const { mapStyle, securityResourceData, backStepInfo } = this.props
  const { attendName,componey,name,phone,address,addressDetail,scope,org,obj,contract, domainid, companyName } = data;
  const that = this;
  var content = [];
  content.push(
    `
    <div >
      <div class="title">${attendName}</div>
      <div class="info-box">
        <div class="info">
          所属公司：<span>${componey}</span>
        </div>
        <div class="info">
          负责人姓名：<span>${name}</span>
        </div>
        <div class="info">
          负责人电话：<span>${phone}</span>
        </div>
        <div class="info">
          驻勤点省市区：<span>${address}</span>
        </div>
        <div class="info">
          驻勤点详细地点：<span>${addressDetail}</span>
        </div>
        <div class="info">
          执勤范围（米）：<span>${scope}</span>
        </div>
        <div class="info">
          所属监管机构：<span>${org}</span>
        </div>
        <div class="info">
          服务对象名称：<span>${obj}</span>
        </div>
        <div class="info">
          合同状态：<span>${contract}</span>
        </div>
      </div>
    </div>
    `
  );
  content.join("<br/>");
  var infoDiv = document.createElement("div");
  infoDiv.className = mapStyle;
  var info = document.createElement("div");
  info.className = "content-window-card-attend";
  infoDiv.appendChild(info);
  // 定义内容
  var middle = document.createElement("div");
  middle.className = "info-middle";
  middle.innerHTML = content;
  info.appendChild(middle);

  //定义2个轨迹服务按钮
  var top = document.createElement("div");
  top.className = "info-button";
  var button = document.createElement("span");
  button.className = "button";
  button.style.margin = "0 10px 0 0";
  button.innerHTML = "驻勤人员信息";
  button.onclick = () => {
    if (type == 'police') {
      this.clear('setPoliceSelectIndex')
      marker.setContent(
        '<div class="amap_lib_placeSearch_poi poibox-icon">' +
        marker.w.indexText +
        "</div>"
      );
    } else {
      this.clear('setPersonSelectIndex')
    }
    eventCenter.emit('initRightDataModule');
    this.props.dispatch({
      type: 'command/clearInfoWindow',
      payload: true
    })
    this.props.dispatch({
      type: 'command/setSelectComponeyInfo',
      payload: {}
    })
    this.props.dispatch({
      type: 'command/setSelectAttendInfo',
      payload: data
    })
    this.props.dispatch({
      type: "command/setMapLayerSwitchState",
      payload: {
        type: 'searchViews',
        value: false
      },
    });
  };
  var button1 = document.createElement("span");
  button1.className = "button";
  button1.innerHTML = "公司信息";
  button1.onclick = () => {
    recordAdd({
      from: 'CreateAttendPointInfoWindow',
      to: 'ComponeyInfo',
      fromData: data,
      toID: domainid
    });
    showCompanyPointInfo({
      doMainId: domainid,
      success: function(info){
        that.props.dispatch({
          type: 'command/setSelectComponeyInfo',
          payload: info
        })
      }
    })
    if (type == 'police') {
      this.clear('setPoliceSelectIndex')
      marker.setContent(
        '<div class="amap_lib_placeSearch_poi poibox-icon">' +
        marker.w.indexText +
        "</div>"
      );
    } else {
      this.clear('setPersonSelectIndex')
    }
  };
  // 定义返回按钮
  if (recordHistory.length > 0) {
    const securityResourceParam = JSON.parse(JSON.stringify(securityResourceData))
    var backBtn = document.createElement("span");
    backBtn.className = "back-btn"
    button.style.margin = "0 10px 0 0";
    backBtn.innerHTML = "返回";
    backBtn.onclick = () => {
      eventCenter.emit('addPictueMarks', {
        data: {
          data: [],
        },
        type: 'securityResource'
      });
      this.props.dispatch({
        type: 'command/setSelectComponeyInfo',
        payload: {}
      })
      this.props.dispatch({
        type: 'command/setSelectAttendInfo',
        payload: {}
      })
      if (type == 'police') {
        this.clear('setPoliceSelectIndex')
      } else {
        this.clear('setPersonSelectIndex')
      }
      recordBack({
        from: 'AttendInfo',
        callback: (result)=>{
          if(result.from == "CreateTrajectoryInfoWindow"){
            recordBack({
              from: result.from,
              callback: (result)=>{
                const data = JSON.parse(JSON.stringify(result));
                recordRemove({
                  from: result.from,
                  toID: result.toID
                })
                recordTo(data, that);
              }
            });
          } else if(result.from == "ComprehensiveSearch"){
            const data = JSON.parse(JSON.stringify(result));
            recordRemove({
              from: result.from,
              toID: result.toID
            })
            recordTo(data, that);
          } else if (result.from == "ComponeyInfo") {
            const data = JSON.parse(JSON.stringify(result));
            recordRemove({
              from: result.from,
              toID: result.toID
            })
            recordTo(data, that);
          }
        }
      });
    }
    info.appendChild(backBtn);
  } else {
    //定义关闭按钮
    var detail = document.createElement("div");
    detail.className = "close-div";
    var a = document.createElement("a");
    a.innerHTML = "x";
    a.onclick = () => {
      // this.state.map.clearInfoWindow();
      //因为police的图层的打点跟列表的选中，没有做更多处理，直接传选中点的信息在这更改，避免需要在生命周期中监听修改的麻烦
      if (type == 'police') {
        this.clear('setPoliceSelectIndex')
        marker.setContent(
          '<div class="amap_lib_placeSearch_poi poibox-icon">' +
          marker.w.indexText +
          "</div>"
        );
      } else {
        this.clear('setPersonSelectIndex')
      }
    };
    detail.appendChild(a);
    info.appendChild(detail);
  }
  top.appendChild(button);
  top.appendChild(button1);
  info.appendChild(top);
  // 定义底部内容
  var bottom = document.createElement("div");
  bottom.className = "info-bottom";
  bottom.style.position = "relative";
  bottom.style.top = "19px";
  bottom.style.margin = "0 auto";
  //  var sharp = document.createElement("img");
  //  sharp.src = "https://webapi.amap.com/images/sharp.png";
  var sharp = document.createElement("div");
  sharp.className = "sharp";
  bottom.appendChild(sharp);
  info.appendChild(bottom);
  return infoDiv;
}
