//实时异常的信息窗体
import { isEmpty } from '@utils/utils';
export default function (data) {
  const { eventType, eventNO, eventName, eventPlace, eventAnnex, position, alarmTime, userName, isSos, userPhone } = data;
  let submitPerson = eventAnnex && JSON.parse(eventAnnex)[0].userName;
  if (isEmpty(submitPerson)) {
    submitPerson = userName;
  }
  var content = [];
  if(isSos){
    content.push(
      "<div><div class='atten-content-text'><div class='text head'>" +
      "紧急事件" +
      "</div><div class='text'>上报地址：" +
      eventPlace +
      "</div><div class='text'>上报时间：" +
      alarmTime +
      "</div><div class='text'>上报人：" +
      submitPerson +
      "</div><div class='text'>上报人联系电话：" +
      userPhone +
      "</div></div>"
    );
  } else {
    content.push(
      "<div><div class='atten-content-text'><div class='text head'>" +
      eventType +
      "</div><div class='text'>事件标题：" +
      eventName +
      "</div><div class='text'>事件编号：" +
      eventNO +
      "</div><div class='text'>事件地址：" +
      eventPlace +
      "</div><div class='text'>事件时间：" +
      alarmTime +
      "</div><div class='text'>提交人：" +
      submitPerson +
      "</div></div>"
    );
  }

  content.join("<br/>");
  var info = document.createElement("div");
  info.className = "content-window-card";
  //可以通过下面的方式修改自定义窗体的宽高
  info.style.width = "300px";
  // 定义内容
  var middle = document.createElement("div");
  middle.className = "info-middle";
  middle.innerHTML = content;
  info.appendChild(middle);
  //定义详情
  var detail = document.createElement("div");
  detail.className = "detail-div";
  info.appendChild(detail);
  // 定义关闭按钮
  var detail = document.createElement("div");
  detail.className = "close-div";
  var a = document.createElement("a");
  a.innerHTML = "x";
  a.onclick = () => {
    this.clear('setSelectIndex')
    if (isSos) {
      eventCenter.emit('clearMapTag', 'eventMarker')
    }
  };
  detail.appendChild(a);
  info.appendChild(detail);

  return info;
}
