import { _DEFAULT_MAP_ZOOM, _DEFAULT_MAP_ZOOMS, _DEFAULT_MAP_CENTER_POINT } from '@constants/maps';

/**
 * 初始化多个页面的地图
 * @param {*} satelliteLayer  解决地球图层到卫星图层的过渡问题
 * @returns
 */
export default function (satelliteLayer) {
  const { AMap, Loca, BMapGL } = window;
  //驻勤点图层
  const normalMap = new AMap.Map("map_container", {
    resizeEnable: true,
    rotateEnable: true,
    pitchEnable: true,
    zoom: _DEFAULT_MAP_ZOOM,
    viewMode: "2D", //开启2D视图
    buildingAnimation: true, //楼块出现是否带动画
    expandZoomRange: true,
    zooms: _DEFAULT_MAP_ZOOMS,
  });
  //人员图层
  const personMap = new AMap.Map("map_container3", {
    resizeEnable: true,
    rotateEnable: true,
    pitchEnable: true,
    zoom: _DEFAULT_MAP_ZOOM,
    viewMode: "2D", //开启2D视图
    buildingAnimation: true, //楼块出现是否带动画
    expandZoomRange: true,
    zooms: _DEFAULT_MAP_ZOOMS
  });
  //防空指挥一张图图层
  const locaMap = new AMap.Map("map_container2", {
    resizeEnable: true,
    rotateEnable: true,
    pitchEnable: true,
    zoom: _DEFAULT_MAP_ZOOM,
    viewMode: "3D", //开启3D视图
    buildingAnimation: true, //楼块出现是否带动画
    expandZoomRange: true,
    zooms: _DEFAULT_MAP_ZOOMS,
    // pitch: 50,
    pitch: 0,
    rotation: 0,
    showBuildingBlock: false,
    showIndoorMap: false,
    layers: [
      // new AMap.TileLayer.Satellite(),
      new AMap.TileLayer.RoadNet(),
      satelliteLayer
    ]
  });
  //警保联动图层
  const policeMap = new AMap.Map("map_container4", {
    // features: ["bg", "road"],
    // mapStyle: "amap://styles/midnight",
    // zoom: 5,
    // viewMode: "2D",
    // skyColor: "#33216a",
    resizeEnable: true,
    rotateEnable: true,
    pitchEnable: true,
    zoom: _DEFAULT_MAP_ZOOM,
    viewMode: "2D", //开启2D视图
    buildingAnimation: true, //楼块出现是否带动画
    expandZoomRange: true,
    zooms: _DEFAULT_MAP_ZOOMS,
  });
  //南宁武装押运管控图层
  const nanNingMap = new AMap.Map("map_container5", {
    resizeEnable: true,
    rotateEnable: true,
    pitchEnable: true,
    zoom: _DEFAULT_MAP_ZOOM,
    viewMode: "2D", //开启2D视图
    buildingAnimation: true, //楼块出现是否带动画
    expandZoomRange: true,
    zooms: _DEFAULT_MAP_ZOOMS
  });
  // 地球图层
  const earthMap = new BMapGL.Map("map_container6");
  earthMap.centerAndZoom(new BMapGL.Point(_DEFAULT_MAP_CENTER_POINT.LATITUDE, _DEFAULT_MAP_CENTER_POINT.LONGITUDE), 3.3677066378158855);  // 初始化地图,设置中心点坐标和地图级别
  earthMap.enableScrollWheelZoom(true);     //开启鼠标滚轮缩放
  earthMap.setMapType(BMAP_EARTH_MAP);
  if (AMap.ControlBar) {
    normalMap.addControl(
      new AMap.ControlBar({
        showZoomBar: false,
        showControlButton: true,
      })
    );
    personMap.addControl(
      new AMap.ControlBar({
        showZoomBar: false,
        showControlButton: true
      })
    );
    locaMap.addControl(
      new AMap.ControlBar({
        showZoomBar: false,
        showControlButton: true,
      })
    );
    policeMap.addControl(
      new AMap.ControlBar({
        showZoomBar: false,
        showControlButton: true,
      })
    );
    nanNingMap.addControl(
      new AMap.ControlBar({
        showZoomBar: false,
        showControlButton: true,
      })
    );
  }
  let infoWindow = new AMap.InfoWindow({
    isCustom: true, //使用自定义窗体
    offset: new AMap.Pixel(16, -45),
  });
  // normalMap.on("zoomchange", (info) => {
  //   let zoom = normalMap.getZoom(); //获取当前地图级别
  // if (zoom > 6) {
  //   for (let i = 0; i < this.state.massDataTotalPage; i++) {
  //     let index = i + 1;
  //     this.state['mass' + index].setStyle({
  //       url: 'https://a.amap.com/jsapi_demos/static/images/mass1.png',
  //       anchor: new AMap.Pixel(3, 3),
  //       size: new AMap.Size(5, 5)
  //     });
  //   }
  // } else {
  //   for (let i = 0; i < this.state.massDataTotalPage; i++) {
  //     let index = i + 1;
  //     this.state['mass' + index].setStyle({
  //       url: 'https://a.amap.com/jsapi_demos/static/images/mass1.png',
  //       anchor: new AMap.Pixel(3, 3),
  //       size: new AMap.Size(1.5, 1.5)
  //     });
  //   }
  // }
  // });
  return {
    normalMap,
    locaMap,
    personMap,
    policeMap,
    nanNingMap,
    earthMap,
    infoWindow
  }
}
