/**
 * 地图页面
 */
import React, { PureComponent } from "react";
import style from "styled-components";
import { connect } from "dva";
import { Form, Layout, Menu, message, Switch } from "antd";
import HeaderMenu from "./Header";
import { CommandRouter } from "./Router";
import { getGISMenu } from '../../services/api';
import { data } from "@constants/TypeData";
import V5page from './V5Page';
import store from "store";
import {gup} from "../../utils/utils"
@connect((state) => ({}))
@Form.create()
export default class Command extends PureComponent {
  constructor(props) {
    super(props);
    const app_type = gup('app_type', window.location.href);
    const saas = store.get('saas') || {};
    store.set('saas', { ...saas, app_type });
    // const currentIndex = app_type==1?0:1 //默认第二个GIS打开
    const currentIndex = 0
    this.state = {
      path: "dataScreen",//初始化第一个页面路径
      menuRouter: CommandRouter,//所有的菜单路由
      currentIndex,
      renderRouter: CommandRouter[currentIndex],//当前渲染的路由
      headerLogo: null
    };
  }

  /******************************生命周期******************************/
  componentWillMount() {
    var script = document.createElement('script');
    script.type = 'text/javascript';
    script.async = true;
    script.src = '/sdk/trtc.js';
    document.head.appendChild(script);
  }
  componentDidMount() {
    this._getGISMenu()
    if (document.querySelector(".ant-layout-header")) {
      // 隐藏左侧菜单栏
      document.querySelector(".ant-layout-sider").style.display = "none";
      document.querySelector(".ant-layout-content").style.margin = "0px";
      // document.querySelector(".oneKeySearchHidden").style.display = "none";
      //隐藏顶部菜单栏
      document.querySelector(".ant-layout-header").style.display = "none";
    }
  }
  componentWillUnmount() {
    if (document.querySelector(".ant-layout-sider")) {
      // 显示左侧菜单栏
      document.querySelector(".ant-layout-sider").style.display = "block";
      document.querySelector(".ant-layout-content").style.margin = "16px";
      // document.querySelector(".oneKeySearchHidden").style.display = "block";
    }
  }
  //获取gis菜单路径
  _getGISMenu() {
    getGISMenu({
      _currpage: 1,
      lines: 100
    }, {
      appId: "__ZLuP7RGirprZZ6SCdiX",
      viewId: "__yCQ9PtckfTJYgpHrgGm",
      opentarget: "detail",
      containTitle: "gis菜单接口",
    }).then(res => {
      if (res.data.total > 0) {
        let data = []
        res.data.data.map(item => {
          if (item.type == 'logo') {
            this.setState({
              headerLogo: item.menuIcon && JSON.parse(item.menuIcon),
              // headerLogo: item.menuIcon && JSON.parse(item.menuIcon)[0] && JSON.parse(item.menuIcon)[0].path,
            })
          } else {
            var value = typeof item.children == 'string' ? JSON.parse(item.children) : item.children
            data.push({
              menuName: item.menuName,
              path: 'v5Page' + item.id,
              component: <V5page menuUrl={item.url} children={value} />
            })
          }
        })
        this.setState({
          menuRouter: CommandRouter.concat(data),
        })
      }
    })
  }
  /******************************相关事件******************************/
  render() {
    const { menuRouter, renderRouter, currentIndex, headerLogo } = this.state
    return (
      <div style={{ padding: 'unset' }}>
        {/* 切换菜单的头部*/}
        <HeaderMenu
          headerLogo={headerLogo}
          currentIndex={currentIndex}
          currentRouter={(item) => {
            this.setState({ path: item.path, renderRouter: item });
          }}
          CommandRouter={menuRouter}
        ></HeaderMenu>
        <div
          style={{
            height: "calc(100vh)",
            paddingTop: '54px'
            // paddingTop: this.state.path == "GIS"|| this.state.path == "dataScreen"? "0" : "54px",
          }}
        >
          {renderRouter && renderRouter.component}
        </div>
      </div>
    );
  }
}

