/**
 * IM可视化视图
 */
import React, { Component } from 'react';
import { Pagination, Drawer, Tooltip, Icon, message } from 'antd';
import './message.less';
import './BenzAMRRecorder';
// import BenzAMRRecorder from 'benz-amr-recorder';
export default class SoundElement extends Component {
  constructor(props) {
    super(props);
    this.state = {
      //   isMine: props.isMine,
      payload: props.payload,
      url: props.payload.url,
      amr: null,
      playState: false
    };
  }

  componentDidMount() {
    // console.log(window.BenzAMRRecorder);
  }
  componentWillReceiveProps(nextProps) {
    this.setState({
      //   isMine: nextProps.isMine,
      payload: nextProps.payload
    });
  }
  play() {
    // 目前移动端的语音消息采用 aac 格式，以前用 amr 格式。默认先用 audio 标签播放，若无法播放则尝试 amr 格式播放。
    const audio = document.createElement('audio');
    audio.addEventListener('error', this.tryPlayAMR()); // 播放出错，则尝试使用 AMR 播放
    audio.src = this.state.url;
    const promise = audio.play();
    if (promise) {
      promise
        .catch(err => {
          console.log('失败');
        })
        .then(res => {
          console.log(res);
          console.log('成功');
        });
    }
  }
  tryPlayAMR() {
    try {
      const isIE = /MSIE|Trident|Edge/.test(window.navigator.userAgent);
      // amr 播放组件库在 IE 不支持
      if (isIE) {
        message.warning(
          '1您的浏览器不支持该格式的语音消息播放，请尝试更换浏览器，建议使用：谷歌浏览器'
        );
        return;
      }
      // 动态插入 amr 播放组件库
      // if (BenzAMRRecorder) {
      //   const script = document.createElement('script');
      //   script.addEventListener('load', this.playAMR());
      //   script.src = '../../../../assets/BenzAMRRecorder.js'; //暂时把文件删掉，好像这么插不进去
      //   const firstScript = document.getElementsByTagName('script')[0];
      //   firstScript.parentNode.insertBefore(script, firstScript);
      //   console.log(firstScript)
      //   document.body.appendChild(script);
      //   return;
      // }
      this.playAMR();
    } catch (error) {
      message.warning(
        '2您的浏览器不支持该格式的语音消息播放，请尝试更换浏览器，建议使用：谷歌浏览器'
      );
    }
  }
  playAMR() {
    let amr = null;
    // if (!this.state.amr && BenzAMRRecorder) {
    amr = new BenzAMRRecorder();
    // }
    // console.log(this.state.amr.isInit());
    // if (this.state.amr.isInit()) {
    //   this.state.amr.play();
    //   return;
    // }
    amr.initWithUrl(this.state.url).then(res => {
      amr.play();
      this.setState({
        playState: true
      });
    });
    amr.onEnded(() => {
      console.log('播放结束');
      this.setState({
        playState: false
      });
    });
  }
  render() {
    //   play的还不行
    return (
      <div
        className="sound-element-wrapper"
        onClick={() => {
          // message.warning('暂时无法播放');
          this.playAMR();
        }}
      >
        {/* <i className="iconfont icon-voice"></i> */}
        <img
          className="sound-img"
          src={
            this.state.playState
              ? require('../../../../assets/images/prevention/vedio-player.gif')
              : require('../../../../assets/images/prevention/vedio-player.png')
          }
        />
        {this.state.payload.second + '"'}
      </div>
    );
  }
}
