/**
 * IM可视化视图
 */
import React, { Component } from 'react';
import { connect } from 'dva';
import { Pagination, Drawer, Tooltip, Icon } from 'antd';
import './message.less';
import TIM from 'tim-js-sdk';
@connect(state => ({
  currentMessageList: state.im.currentMessageList
}))
export default class ImageElement extends Component {
  constructor(props) {
    super(props);
    this.state = {
      //   isMine: props.isMine,
      payload: props.payload,
      imagePreviewerStatus: false, //预览图片弹窗状态
      imgUrlList: [], //会话中的所有图片列表
      zoom: 1,
      index: 0
    };
  }

  componentDidMount() {
    this.setState({
      imgUrlList: this.imgUrlList()
    });
  }
  imgUrlList() {
    return this.props.currentMessageList
      .filter(message => message.type === TIM.TYPES.MSG_IMAGE)
      .map(message => message.payload.imageInfoArray[0].url);
  }
  componentWillReceiveProps(nextProps) {
    this.setState({
      //   isMine: nextProps.isMine,
      payload: nextProps.payload
    });
  }
  formatUrl(url) {
    if (!url) {
      return '';
    }
    return url.slice(0, 2) === '//' ? `https:${url}` : url;
  }
  render() {
    let imageUrl = '';
    const url = this.state.payload.imageInfoArray[0].url;
    if (typeof url !== 'string') {
      imageUrl = '';
    }
    imageUrl = url.slice(0, 2) === '//' ? `https:${url}` : url;
    return (
      <div>
        <img
          className="image-element"
          src={imageUrl}
          onClick={() => {
            this.setState({
              imagePreviewerStatus: true
            });
          }}
        />
        {/* <el-progress
      v-if="showProgressBar"
      :percentage="percentage"
      :color="percentage => (percentage === 100 ? '#67c23a' : '#409eff')"
    /> */}
        <div
          className="image-previewer-wrapper"
          style={{
            display: this.state.imagePreviewerStatus ? 'block' : 'none'
          }}
        >
          <div className="image-wrapper">
            <img
              className="image-preview"
              // style="{transform: `scale(${zoom}) rotate(${rotate}deg)`}"
              src={this.formatUrl(this.state.imgUrlList[this.state.index])}
              // @click="close"
            />
          </div>
          <Icon
            type="close"
            className="close-button"
            onClick={() => {
              this.setState({
                imagePreviewerStatus: false
              });
            }}
          />
          {/* <i class="el-icon-back prev-button" @click="goPrev"></i>
    <i class="el-icon-right next-button" @click="goNext"></i>
    <div class="actions-bar">
      <i class="el-icon-zoom-out" @click="zoomOut"></i>
      <i class="el-icon-zoom-in" @click="zoomIn"></i>
      <i class="el-icon-refresh-left" @click="rotateLeft"></i>
      <i class="el-icon-refresh-right" @click="rotateRight"></i>
      <span class="image-counter">{{index+1}} / {{imgUrlList.length}}</span>
    </div> */}
        </div>
      </div>
    );
  }
}
