/**
 * 录制记录列表
 */
import React, { Component } from "react";
import { connect } from "dva";
import { Layout } from "antd";
import styles from "./header.less";
import {gup} from "../../../utils/utils";
const { Header } = Layout;
@connect((state) => ({
  mapStyle: state.command.mapStyle,
  layoutAuthority: state.command.layoutAuthority
}))
export default class HeaderMenu extends Component {
  constructor(props) {
    super(props);
    this.state = {
      currentGroup: props.currentIndex,
    };
  }
  componentDidMount() {

  }
  render() {
    const { CommandRouter, headerLogo, mapStyle, layoutAuthority } = this.props
    let _CommandRouter = CommandRouter.filter(item => item.menuName != "")
    return (
      <Header className={styles.header + ' ' + styles[mapStyle]}>
        <div className={styles.logo}>
          {
            // (headerLogo && headerLogo.length > 0) && <img src={mapStyle == 'dark' ? headerLogo[1] && headerLogo[1].path : headerLogo[0] && headerLogo[0].path} style={{ maxWidth: '186px' }} />
            layoutAuthority.commonLogo && layoutAuthority.darkLogo ?
              <img src={mapStyle == 'dark' ? layoutAuthority.darkLogo : layoutAuthority.commonLogo} style={{ maxWidth: '186px' }} /> :
              (headerLogo && headerLogo.length > 0) && <img src={mapStyle == 'dark' ? headerLogo[1] && headerLogo[1].path : headerLogo[0] && headerLogo[0].path} style={{ maxWidth: '186px' }} />

          }
          {/* <h1>{headerLogoName}</h1> */}
        </div>
        <div className={styles.commandMenu}>
          {_CommandRouter.map((item, index) => {
            return (
              <a
                key={index}
                onClick={() => {
                  this.props.currentRouter(item);
                  this.setState({
                    currentGroup: index,
                  });
                  if (index == 1) {
                    window.location.reload();
                    return;
                  }
                  if (item.path == 'dataScreen') {
                    // this.props.dispatch({
                    //   type: 'command/setMapStyle',
                    //   payload: 'dark'
                    // })
                  } else {
                    this.props.dispatch({
                      type: 'command/setMapStyle',
                      payload: 'normal'
                    })
                  }
                }}
                className={
                  this.state.currentGroup === index ? styles.selected : ""
                }
              >
                {item.menuName}
              </a>
            );
          })}
        </div>
      </Header>
    );
  }
}
